<?php
function validateHeaderProcess($validationRules,$data){
        $errors = [];
    
    foreach ($validationRules as $field => $rule) {
        // Verificar si el campo es obligatorio
        if ($rule['required'] && !isset($data[$field])) {
            $errors[] = "Field '$field' is required";
            continue;
        }
        // Si el campo no está presente y no es obligatorio, continuar
        if (!isset($data[$field]) && !$rule['required']) {
            continue;
        }
        // Verificar si el campo puede estar vacio
        if ($rule['notEmpty'] && $data[$field]==""){
            $errors[] = "Field '$field' must not be empty";
            continue;
        }
        
        if(isset($rule['isStatus']) && !($data[$field] === "ACTIVO" || $data[$field] === "INACTIVO" || $data[$field] === "BLOQUEADO")){
            $errors[] = "Field '$field' accepts only ACTIVO, INACTIVO OR BLOQUEADO values";
            continue;
        }

        $value = $data[$field];
        
        // Validar tipo de dato
        switch ($rule['type']) {
            case 'string':
                if (!is_string($value)) $errors[] = "Field '$field' must be a string";
                if (isset($rule['max_length']) && strlen($value) > $rule['max_length']) $errors[] = "Field '$field' exceeds maximum length of {$rule['max_length']}";
                if (isset($rule['length']) && strlen($value) != $rule['length']) $errors[] = "Field '$field' has a length other than {$rule['length']}";
                break;
            case 'integer':
                if (!is_numeric($value) || floor($value) != $value) $errors[] = "Field '$field' must be an integer";
                if (isset($rule['min']) && $value < $rule['min']) $errors[] = "Field '$field' must be at least {$rule['min']}";
                if (isset($rule['max']) && $value > $rule['max']) $errors[] = "Field '$field' must not exceed {$rule['max']}";
                break;
            case 'email':
                if (!filter_var($value, FILTER_VALIDATE_EMAIL)) $errors[] = "Field '$field' must be a valid email address";
                break;
            case 'boolean':
                if (!is_bool($value) && $value !== 0 && $value !== 1) $errors[] = "Field '$field' must be a boolean";
                break;
            case 'datetime':
                $format = 'Y-m-d H:i:s';
                $dateTime = DateTime::createFromFormat($format, $value);
                if (!$dateTime || $dateTime->format($format) !== $value) $errors[] = "Field '$field' must be a valid datetime (YYYY-MM-DD HH:MM:SS)";
                break;
            case 'date':
                $format = 'Y-m-d';
                $dateTime = DateTime::createFromFormat($format, $value);
                if (!$dateTime || $dateTime->format($format) !== $value) $errors[] = "Field '$field' must be a valid datetime (YYYY-MM-DD)";
                break;
        }
    
    }
    return $errors;
}
class ValidateHeader{
    public static function validate($data){
        $validationRules = [
            'Business-Id' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => true
            ],
            'User-Id' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => true
            ],
            'Authorization' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true
            ]
        ];
        $errors = validateHeaderProcess($validationRules,$data);
        return $errors;
    }
}
?>