<?php
require_once 'controllers/RegionController.php';
class Router {
    private $controller;
    private $method;
    private $uri;
    private $id;
    private $typeResource;
    public function __construct($mysqli,$header) {
        $this->method = $_SERVER['REQUEST_METHOD'];
        $this->uri = $_SERVER['REQUEST_URI'];
        $partes = array_filter(explode('/', rtrim($this->uri, '/')));
        $resource = isset($partes[3]) ? $partes[3] : '';
        $this->typeResource = $resource;
        $this->id = isset($partes[4]) && is_numeric($partes[4]) ? (int)$partes[4] : null;
        if ($resource === 'listar-region' || $resource === 'listar-provincia' || $resource === 'listar-comuna') {
            $this->controller = new RegionController($mysqli,$header);
        }else {
            ApiResponse::error('E002','Recurso '.$resource.' no encontrado');
        }
    }
    public function route($header) {
        switch ($this->method) {
            case 'GET':
                switch($this->typeResource){
                    case 'listar-region':
                        $this->controller->getRegion();
                        break;
                    case 'listar-provincia':
                        if(!$this->id) ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        $this->controller->getProvincias($this->id);
                        break;
                    case 'listar-comuna':
                        if(!$this->id) ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        $this->controller->getComunas($this->id);
                        break;
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            default:
                ApiResponse::error('E001');
                break;
        }
    }
}
?>