<?php
class ValidateUser{
    private $mysqli;

    public function __construct($mysqli) {
        $this->mysqli = $mysqli;
        $this->mysqli->set_charset("utf8mb4");
    }

    public function validateUser($sessionCode,$sub,$iat,$exp,$iss,$role){
        $sql = "select * from __sessionregister where  
            sessionCode = ? and
            sub = ? and
            iat = ? and
            exp = ? and
            iss = ? and
            role = ?
            ";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception ('Error en el proceso de validacion del accessToken');
        }
        $stmt->bind_param("ssssss", $sessionCode, $sub, $iat, $exp, $iss, $role);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();
        $stmt->close();
        return $user;
        
    }
}