<?php
 class Region{
    private $mysqli;
    private $header;

    public function __construct($mysqli,$header) {
        $this->mysqli = $mysqli;
        $this->mysqli->set_charset("utf8mb4");
        $this->header = $header;
    }
    public function getAllRegion(){
        $sql = "SELECT id,nombre FROM __region;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $region[] = $row;
        }
        $stmt->close();
        return $region;
    }
    public function getProvinciasByIdRegion($id){
        $sql = "SELECT id,nombre FROM __provincia WHERE idRegion = ?;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param("i",$id);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $provincias[] = $row;
        }
        $stmt->close();
        if(isset($provincias)){
            return $provincias;
        }else{
            return false;
        }  
    }
    public function getComunaByIdProvincias($id){
        $sql = "SELECT id,nombre FROM __comuna WHERE idProvincia = ?;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param("i",$id);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $comunas[] = $row;
        }
        $stmt->close();
        if(isset($comunas)){
            return $comunas;
        }else{
            return false;
        }
    }
    public function getListBusinessActive(){
        
        $sql = "SELECT id,CONCAT(rut,'-',dv) AS rut,nombre FROM __empresa WHERE estado = 'ACTIVO' ORDER BY fecha_creacion desc";

        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $dataBusiness[] = $row;
        }
        $stmt->close();
        return $dataBusiness;
    }
    public function updateUserById($id,$modParam){
        $sql = "UPDATE __usuarios SET ";
        $params = [];
        $types = "";
        $values = [];
        if ($modParam['nombre'] !== null) {
            $sql .= "nombre = ?, ";
            $types .= "s";
            $values[] = $modParam['nombre'];
        }
        if ($modParam['apellido_1'] !== null) {
            $sql .= "apellido_1 = ?, ";
            $types .= "s";
            $values[] = $modParam['apellido_1'];
        }
        if ($modParam['apellido_2'] !== null) {
            $sql .= "apellido_2 = ?, ";
            $types .= "s";
            $values[] = $modParam['apellido_2'];
        }
        if ($modParam['email'] !== null) {
            $sql .= "email = ?, ";
            $types .= "s";
            $values[] = $modParam['email'];
        }
        if ($modParam['contrasena'] !== null && $modParam['hash_auth'] !== null) {
            $sql .= "contrasena = ?, hash_auth = ?, estado = 'ACTIVO', fecha_ultimo_cambio = now(), fecha_bloqueo = NULL";
            $types .= "ss";
            $values[] = $modParam['contrasena'];
            $values[] = $modParam['hash_auth'];
        }
        if ($modParam['estado'] !== null) {
            $sql .= "estado = ?, ";
            $types .= "s";
            $values[] = $modParam['estado'];
        }
        if(count($values) == 0) throw new Exception('E007');
        $types .= "i"; // Para evaluationId
        $values[] = $id;
        $sql = rtrim($sql, ", ") . " WHERE id = ?";

        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param($types, ...$values);
        if (!$stmt->execute()) {
            throw new Exception("Error al actualizar: " . $stmt->error);
        }
        $affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $affected_rows;
    }
    public function deleteUser($id){
        $sql = "UPDATE __usuarios SET estado = 'INACTIVO', fecha_eliminacion = NOW() WHERE id = ?;";

        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param('i', $id);
        if (!$stmt->execute()) {
            throw new Exception("Error al actualizar: " . $stmt->error);
        }
        $affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $affected_rows;
    }
}