<?php
 class ProfileUser{
    private $mysqli;
    private $header;

    public function __construct($mysqli,$header) {
        $this->mysqli = $mysqli;
        $this->mysqli->set_charset("utf8mb4");
        $this->header = $header;
    }
    public function getAllUser(){
        $sql = "SELECT 
            u.id,
            u.nombre,
            u.apellido_1,
            u.apellido_2,
            u.email,
            u.estado,
            u.nombre_usuario,
            e.nombre AS nombre_empresa,
            e.id AS id_empresa,
            u.fecha_creacion,
            p.tipo as tipo_perfil,
            p.nombre as nombre_perfil
        FROM __usuarios u 
        LEFT JOIN __empresa e ON u.id_empresa=e.id
        LEFT JOIN __usuario_perfil up ON up.id_usuario = u.id
        LEFT JOIN __perfil p ON p.id = up.id_perfil
        ORDER BY u.fecha_creacion desc;";

        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $users[] = $row;
        }
        $stmt->close();
        return $users;
    }
    public function getResumenUser(){
        $sql = "SELECT 
            estado,
            total
        FROM (
            SELECT 
                COALESCE(e.estado, 'TOTAL') AS estado,
                COALESCE(COUNT(em.estado), 0) AS total
            FROM (
                SELECT 'ACTIVO' AS estado
                UNION
                SELECT 'INACTIVO'
                UNION
                SELECT 'BLOQUEADO'
            ) e
            LEFT JOIN __usuarios em ON e.estado = em.estado
            GROUP BY e.estado WITH ROLLUP
        ) result
        ORDER BY 
            CASE 
                WHEN estado = 'TOTAL' THEN 4 
                WHEN estado = 'ACTIVO' THEN 1 
                WHEN estado = 'INACTIVO' THEN 2 
                WHEN estado = 'BLOQUEADO' THEN 3 
            END;";

        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $dataResumen[] = $row;
        }
        $stmt->close();
        return $dataResumen;
    }
    public function createUser($nombre, $apellido1, $apellido2, $email, $nombre_usuario, $contrasena, $hash_auth, $id_empresa){
        $sql = "INSERT INTO __usuarios (nombre,apellido_1,apellido_2,email,nombre_usuario,contrasena,hash_auth,id_empresa) VALUES(?,?,?,?,?,?,?,?);";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param("sssssssi", $nombre,$apellido1,$apellido2,$email,$nombre_usuario,$contrasena,$hash_auth,$id_empresa);
        if (!$stmt->execute()) {
            throw new Exception("Error al crear: " . $stmt->error);
        }
        $id = $this->mysqli->insert_id;
        $stmt->close();
        return $id;
    }
    public function createUserProfile($id_usuario,$id_perfil){
        $sql = "INSERT INTO __usuario_perfil(id_usuario,id_perfil) VALUES(?,?);";
         $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param("ii",$id_usuario,$id_perfil);
        if (!$stmt->execute()) {
            throw new Exception("Error al crear: " . $stmt->error);
        }
        $id = $this->mysqli->insert_id;
        $stmt->close();
    }
    public function getAllProfile(){
        $sql = "SELECT id,nombre FROM __perfil";
         $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $profile[] = $row;
        }
        $stmt->close();
        return $profile;
    }
    public function getAdminProfiles(){
        $sql = "SELECT id,nombre FROM __perfil WHERE tipo NOT IN ('SUPERADMIN')";
         $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $profile[] = $row;
        }
        $stmt->close();
        return $profile;
    }
    public function getUserById($userId,$businessId){
        $sql = "SELECT 
            u.id,
            u.nombre,
            u.apellido_1,
            u.apellido_2,
            u.email,
            u.estado,
            u.nombre_usuario,
            e.nombre AS nombre_empresa,
            e.id AS id_empresa,
            u.fecha_creacion,
            p.tipo as tipo_perfil,
            p.nombre as nombre_perfil
        FROM __usuarios u 
        LEFT JOIN __empresa e ON u.id_empresa=e.id
        LEFT JOIN __usuario_perfil up ON up.id_usuario = u.id
        LEFT JOIN __perfil p ON p.id = up.id_perfil
        WHERE u.id = ? AND e.id=?;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param("ii",$userId,$businessId);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $user[] = $row;
        }
        $stmt->close();
        if(isset($user)){
            return $user;
        }else{
            return false;
        }
    }
    public function getUserByIdSuperadmin($userId){
        $sql = "SELECT 
            u.id,
            u.nombre,
            u.apellido_1,
            u.apellido_2,
            u.email,
            u.estado,
            u.nombre_usuario,
            e.nombre AS nombre_empresa,
            e.id AS id_empresa,
            u.fecha_creacion,
            p.tipo as tipo_perfil,
            p.nombre as nombre_perfil
        FROM __usuarios u 
        LEFT JOIN __empresa e ON u.id_empresa=e.id
        LEFT JOIN __usuario_perfil up ON up.id_usuario = u.id
        LEFT JOIN __perfil p ON p.id = up.id_perfil
        WHERE u.id = ?;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param("i",$userId);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $user[] = $row;
        }
        $stmt->close();
        if(isset($user)){
            return $user;
        }else{
            return false;
        }
    }
    public function getListBusinessActive(){
        
        $sql = "SELECT id,CONCAT(rut,'-',dv) AS rut,nombre FROM __empresa WHERE estado = 'ACTIVO' ORDER BY fecha_creacion desc";

        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $dataBusiness[] = $row;
        }
        $stmt->close();
        return $dataBusiness;
    }
    public function updateUserById($id,$modParam){
        $sql = "UPDATE __usuarios SET ";
        $params = [];
        $types = "";
        $values = [];
        if ($modParam['nombre'] !== null) {
            $sql .= "nombre = ?, ";
            $types .= "s";
            $values[] = $modParam['nombre'];
        }
        if ($modParam['apellido_1'] !== null) {
            $sql .= "apellido_1 = ?, ";
            $types .= "s";
            $values[] = $modParam['apellido_1'];
        }
        if ($modParam['apellido_2'] !== null) {
            $sql .= "apellido_2 = ?, ";
            $types .= "s";
            $values[] = $modParam['apellido_2'];
        }
        if ($modParam['email'] !== null) {
            $sql .= "email = ?, ";
            $types .= "s";
            $values[] = $modParam['email'];
        }
        if ($modParam['contrasena'] !== null && $modParam['hash_auth'] !== null) {
            $sql .= "contrasena = ?, hash_auth = ?, estado = 'ACTIVO', fecha_ultimo_cambio = now(), fecha_bloqueo = NULL";
            $types .= "ss";
            $values[] = $modParam['contrasena'];
            $values[] = $modParam['hash_auth'];
        }
        if ($modParam['estado'] !== null) {
            $sql .= "estado = ?, ";
            $types .= "s";
            $values[] = $modParam['estado'];
        }
        if(count($values) == 0) throw new Exception('E007');
        $types .= "i"; // Para evaluationId
        $values[] = $id;
        $sql = rtrim($sql, ", ") . " WHERE id = ?";

        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param($types, ...$values);
        if (!$stmt->execute()) {
            throw new Exception("Error al actualizar: " . $stmt->error);
        }
        $affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $affected_rows;
    }
    public function deleteUser($id){
        $sql = "UPDATE __usuarios SET estado = 'INACTIVO', fecha_eliminacion = NOW() WHERE id = ?;";

        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param('i', $id);
        if (!$stmt->execute()) {
            throw new Exception("Error al actualizar: " . $stmt->error);
        }
        $affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $affected_rows;
    }
    public function bloquearUsuario($id){
        $sql = "CALL sp_bloquear_usuario(?, ?, ?, @p_rows_affected);";
        $types = "iis";
        switch ($this->header['profile']) {
            case 'SUPERADMIN':
                $values = array($id,NULL,$this->header['profile']);
                break;
            case 'ADMIN':
                $values = array($id,$this->header['Business-Id'],$this->header['profile']);
                break;
            default:
                throw new Exception("E401");
                break;
        }
        $resp = $this->executeProcedureUpdate($sql,$types,$values);
        return $resp;
    }

    private function executeProcedureUpdate($sql,$types,$values){
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("E501", $this->mysqli->error);
        }
        $stmt->bind_param($types, ...$values);
        $stmt->execute();
        $stmt->close();
        while ($this->mysqli->more_results() && $this->mysqli->next_result()) {
            if ($res = $this->mysqli->use_result()) { $res->free(); }
        }
        $res = $this->mysqli->query("SELECT @p_rows_affected AS filas_afectadas");
        $filas_afectadas = $res->fetch_assoc()['filas_afectadas'] ?? null;
        $res->free();
        return $filas_afectadas;
    }
}