<?php
require_once __DIR__ .'/../models/TemplateEvaluacion.php';
class TemplateEvaluacionController {
    private $templateEvaluacionModel;
    private $dataErrors = [];
    private $header;
    public function __construct($mysqli,$header){
        $this->templateEvaluacionModel = new TemplateEvaluacion($mysqli,$header);
        $this->header = $header;
    }
    public function getResumen(){
        try {
            if($this->header['profile'] !='SUPERADMIN') throw new Exception('E401');   
            $business = $this->templateEvaluacionModel->getResumen();
            if(!$business) throw new Exception("E404");
            $resp = $this->formateaResumen($business);
            if($resp) ApiResponse::success('S001',$resp); throw new Exception("E404"); 
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function getOrganizationType(){
        try {
            if($this->header['profile'] !='SUPERADMIN') throw new Exception('E401');   
            if($business = $this->templateEvaluacionModel->getAllOrganizationType()) ApiResponse::success('S001',$business); throw new Exception('E404');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function getTemplateType(){
        try {
            if($template = $this->templateEvaluacionModel->getAllTemplateType()) ApiResponse::success('S001',$template); throw new Exception('E404');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function getTemplateTypeById($id){
        try{
            $typeTemplate = $this->templateEvaluacionModel->getTemplateTypeById($id);
            if($typeTemplate){
                $template = $this->templateEvaluacionModel->getAllTemplateByType($id);
                if(!$template) throw new Exception("E404");
                $resp = $this->formateaPlantillas($template);
                ApiResponse::success('S001',$resp);
            }else{
                throw new Exception("E404"); 
            }
        }catch (Exception $e){
            ApiResponse::error($e->getMessage());
        }
    }
    public function getAllTemplate(){
        try{
            $template = $this->templateEvaluacionModel->getAllTemplate();
            if(!$template) throw new Exception("E404");
            $resp = $this->formateaPlantillas($template);
            ApiResponse::success('S001',$resp);
        }catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function getTemplateById($id){
        try{
            if($this->header['profile'] ==='SUPERADMIN') $template = $this->templateEvaluacionModel->getTemplateById($id); $template = $this->templateEvaluacionModel->getTemplateById($id,true);
            if($template) ApiResponse::success('S001',$template); throw new Exception("E404");
        }catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function getDimensionByRoleId($id){
        try{
            if($template = $this->templateEvaluacionModel->getDimensionByRoleId($id)) ApiResponse::success('S001',$template); throw new Exception("E404");
        }catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function getSubdimension($data){
        try{
            if($template = $this->templateEvaluacionModel->getSubDimension($data)) ApiResponse::success('S001',$template); throw new Exception("E404");
        }catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function getSubdimensionById($id){
        try{
            if($template = $this->templateEvaluacionModel->getSubDimensionById($id)) ApiResponse::success('S001',$template); throw new Exception("E404");
        }catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function getIndicadorDesempenoByDimension($id){
        try{
            $outp = $this->templateEvaluacionModel->getIndicadorDesempenoByDimension($id);
            if(!$outp) throw new Exception("E404");
            $resp = $this->formateaIndicadorDesempeno($outp);
            if($resp) ApiResponse::success('S001',$resp); throw new Exception("E404");
        }catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function getIndicadorDesempenoBySubdimension($id){
        try{
            $outp = $this->templateEvaluacionModel->getIndicadorDesempenoBySubdimension($id);
            if(!$outp) throw new Exception("E404");
            $resp = $this->formateaIndicadorDesempeno($outp);
            if($resp) ApiResponse::success('S001',$resp); throw new Exception("E404");
        }catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function getIndicadorDesempenoByRol($id){
        try{
            $outp = $this->templateEvaluacionModel->getIndicadorDesempenoByRol($id);
            if(!$outp) throw new Exception("E404");
            $resp = $this->formateaIndicadorDesempeno($outp);
            if($resp) ApiResponse::success('S001',$resp); throw new Exception("E404");
        }catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function createTemplate($data, $file){
        //se debe diseñar y agregar la logica de validacion del csv
        try {
            $typeOrganization = $data['tipo-organizacion'];
            $typeTemplate = $data['tipo-plantilla'];
            $role = 0;
            $dimensions = [];
            $subdimensions = [];
            if (($handle = fopen($file['plantilla']['tmp_name'], "r")) !== false) {
                while (($row = fgetcsv($handle, 0, ";",'"','\\')) !== false) {
                    $type = $row[0];

                    switch ($type) {
                        case 'R':
                            // Role: R;coordinadora de soporte
                            if(!isset($row[2])) $row[2]=null;
                            $role = $this->templateEvaluacionModel->saveRol($row[1],$row[2],$typeOrganization,$typeTemplate);
                            break;
                        case 'D':
                            // Dimension: D;number;description
                            $dimensionId = $this->templateEvaluacionModel->saveDimension($role,$row[2]);
                            $dimensions[$row[1]] = $dimensionId;
                            break;

                        case 'SD':
                            // Subdimension: SD;dimension_number;subdimension1|subdimension2
                            for($i=2; $i<count($row); $i++){
                                $parseSubdimension = explode('|', $row[$i]);
                                $subdimensionId = $this->templateEvaluacionModel->saveSubdimension($dimensions[$row[1]],$parseSubdimension[1],$role);
                                $subdimensions[$row[1]][$parseSubdimension[0]] = $subdimensionId;
                            }
                            break;

                        case 'ID':
                            // Indicator: ID;dimension_number;subdimension_number;description
                            if($row[2]==""){
                                $indicatorID = $this->templateEvaluacionModel->saveIndicatorWithoutSubdimension($dimensions[$row[1]],$row[3],$role);
                            }else{
                                $indicatorID = $this->templateEvaluacionModel->saveIndicatorWithSubdimension($dimensions[$row[1]],$row[3],$subdimensions[$row[1]][$row[2]],$role);
                            }
                            break;
                    }
                }
                fclose($handle);
                $respuesta = array("id-plantilla"=>$role);
                ApiResponse::success('S001',$respuesta);
            }else{
                throw new Exception("E500");     
            }
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    /* --- funciones de actualizacion de datos de las plantillas ---
    servicio de actualizacion de datos correspondientes al nivel de plantilla: los datos permitidos para la realización de estas modificaciones son: nombre,descripcion,estado,id_tipo_organizacion,id_tipo_plantilla*/
    public function updateTemplateById($id, $data){ 
        try {
            if($this->header['profile'] != 'SUPERADMIN') throw new Exception("E401");
            $update = $this->templateEvaluacionModel->updateTemplateById($id,$data);
            if($update['c'] == 0) throw new Exception("E404");
            if($update['c'] == 1 and $update['m'] == 0) ApiResponse::success('S001','No se han realizado cambios al registro');
            ApiResponse::success('S001','Registro actualizado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function updateDimensionById($id, $data){ 
        try {
            if($this->header['profile'] != 'SUPERADMIN') throw new Exception("E401");
            $update = $this->templateEvaluacionModel->updateDimensionById($id,$data);
            if($update['c'] == 0) throw new Exception("E404");
            if($update['c'] == 1 and $update['m'] == 0) ApiResponse::success('S001','No se han realizado cambios al registro');
            ApiResponse::success('S001','Registro actualizado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function updateSubDimensionById($id, $data){ 
        try {
            if($this->header['profile'] != 'SUPERADMIN') throw new Exception("E401");
            $update = $this->templateEvaluacionModel->updateSubDimensionById($id,$data);
            if($update['c'] == 0) throw new Exception("E404");
            if($update['c'] == 1 and $update['m'] == 0) ApiResponse::success('S001','No se han realizado cambios al registro');
            ApiResponse::success('S001','Registro actualizado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function updateIndicadorDesempenoById($id, $data){ 
        try {
            if($this->header['profile'] != 'SUPERADMIN') throw new Exception("E401");
            $update = $this->templateEvaluacionModel->updateIndicadorDesempenoById($id,$data);
            if($update['c'] == 0) throw new Exception("E404");
            if($update['c'] == 1 and $update['m'] == 0) ApiResponse::success('S001','No se han realizado cambios al registro');
            ApiResponse::success('S001','Registro actualizado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    /* --- funciones de eliminacion de los datos de las plantillas*/
    public function deletePlantillaById($id){
        try {
            if($this->header['profile'] != 'SUPERADMIN') throw new Exception("E401");
            $delete = $this->templateEvaluacionModel->deletePlantillaById($id);
            if($delete['m'] == 0) ApiResponse::error('E404','No se ha encontrado registro para eliminar');
            ApiResponse::success('S001','Registro eliminado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function deleteDimensionById($id){
        try {
            if($this->header['profile'] != 'SUPERADMIN') throw new Exception("E401");
            $delete = $this->templateEvaluacionModel->deleteDimensionById($id);
            if($delete['m'] == 0) ApiResponse::error('E404','No se ha encontrado registro para eliminar');
            ApiResponse::success('S001','Registro eliminado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function deleteSubDimensionById($id){
        try {
            if($this->header['profile'] != 'SUPERADMIN') throw new Exception("E401");
            $delete = $this->templateEvaluacionModel->deleteSubDimensionById($id);
            if($delete['m'] == 0) ApiResponse::error('E404','No se ha encontrado registro para eliminar');
            ApiResponse::success('S001','Registro eliminado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function deleteIndicadorDesempenoById($id){
        try {
            if($this->header['profile'] != 'SUPERADMIN') throw new Exception("E401");
            $delete = $this->templateEvaluacionModel->deleteIndicadorDesempenoById($id);
            if($delete['m'] == 0) ApiResponse::error('E404','No se ha encontrado registro para eliminar');
            ApiResponse::success('S001','Registro eliminado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    /* --- funciones privadas de la clase
    private function formateaIndicadorDesempeno($data){
        $grouped = [];

        foreach ($data as $row) {
            // clave de agrupación estable
            $key = implode('|', [
                (string)($row['id_dimension'] ?? ''),
                (string)($row['nombre_dimension'] ?? ''),
                (string)($row['id_subdimension'] ?? ''),
                (string)($row['nombre_subdimension'] ?? ''),
                (string)($row['id_evaluacion'] ?? ''),
                (string)($row['nombre_evaluacion'] ?? '')
            ]);

            if (!isset($grouped[$key])) {
                $grouped[$key] = [
                    'id_evaluacion'      => $row['id_evaluacion'] ?? null,
                    'nombre_evaluacion'      => $row['nombre_evaluacion'] ?? null,
                    'id_dimension'       => $row['id_dimension'] ?? null,
                    'nombre_dimension'    => $row['nombre_dimension'] ?? null,
                    'id_subdimension'    => $row['id_subdimension'] ?? null,
                    'nombre_subdimension'=> $row['nombre_subdimension'] ?? null,
                    'indicador_desempeno'=> [] // <— con ñ, preservado en UTF-8
                ];
            }

            // arma cada indicador con los campos que quieres mostrar
            $indicator = [];
            if (array_key_exists('id_indicador_desempeno', $row)) {
                $indicator['id_indicador_desempeno'] = $row['id_indicador_desempeno'];
            }
            if (array_key_exists('nombre_indicador_desempeno', $row)) {
                $indicator['nombre_indicador_desempeno'] = $row['nombre_indicador_desempeno'];
            }

            $grouped[$key]['indicador_desempeno'][] = $indicator;
        }

        $output = array_values($grouped);
        return $output;
    }*/



    private function formateaIndicadorDesempeno(array $data): array
{
    $out = []; // mapa por id_evaluacion

    foreach ($data as $row) {
        $idEval  = $row['id_evaluacion']   ?? null;
        $nomEval = $row['nombre_evaluacion'] ?? null;

        $idDim   = $row['id_dimension']    ?? null;
        $nomDim  = $row['nombre_dimension'] ?? null;

        $idSub   = $row['id_subdimension'] ?? null;
        $nomSub  = $row['nombre_subdimension'] ?? null;

        // --- Inicializa Evaluación ---
        if (!isset($out[$idEval])) {
            $out[$idEval] = [
                'id_evaluacion'     => $idEval,
                'nombre_evaluacion' => $nomEval,
                'dimensiones'       => [],              // mapa por id_dimension
            ];
        }

        // --- Inicializa Dimensión ---
        if (!isset($out[$idEval]['dimensiones'][$idDim])) {
            $out[$idEval]['dimensiones'][$idDim] = [
                'id_dimension'        => $idDim,
                'nombre_dimension'    => $nomDim,
                'indicador_desempeno' => [],           // indicadores sin subdimensión
                'subdimensiones'      => [],           // mapa por id_subdimension
                // opcional: mapas para deduplicar por id_indicador
                '_seen_no_sub'        => [],
            ];
        }

        // --- Arma el indicador (solo si trae contenido) ---
        $indicator = [];
        if (isset($row['id_indicador_desempeno'])) {
            $indicator['id_indicador_desempeno'] = $row['id_indicador_desempeno'];
        }
        if (isset($row['nombre_indicador_desempeno'])) {
            $indicator['nombre_indicador_desempeno'] = $row['nombre_indicador_desempeno'];
        }
        if ($indicator === []) {
            continue; // evita empujar objetos vacíos
        }

        // --- Enruta indicador: a subdimensión (si existe) o a la dimensión ---
        if ($idSub !== null) {
            // Inicializa subdimensión
            if (!isset($out[$idEval]['dimensiones'][$idDim]['subdimensiones'][$idSub])) {
                $out[$idEval]['dimensiones'][$idDim]['subdimensiones'][$idSub] = [
                    'id_subdimension'     => $idSub,
                    'nombre_subdimension' => $nomSub,
                    'indicador_desempeno' => [],
                    '_seen'               => [], // deduplicación opcional
                ];
            }
            // deduplicación opcional por id_indicador_desempeno
            $iid = $indicator['id_indicador_desempeno'] ?? null;
            if ($iid !== null) {
                if (isset($out[$idEval]['dimensiones'][$idDim]['subdimensiones'][$idSub]['_seen'][(string)$iid])) {
                    continue;
                }
                $out[$idEval]['dimensiones'][$idDim]['subdimensiones'][$idSub]['_seen'][(string)$iid] = true;
            }
            $out[$idEval]['dimensiones'][$idDim]['subdimensiones'][$idSub]['indicador_desempeno'][] = $indicator;

        } else {
            // indicador al nivel de la dimensión
            $iid = $indicator['id_indicador_desempeno'] ?? null;
            if ($iid !== null) {
                if (isset($out[$idEval]['dimensiones'][$idDim]['_seen_no_sub'][(string)$iid])) {
                    continue;
                }
                $out[$idEval]['dimensiones'][$idDim]['_seen_no_sub'][(string)$iid] = true;
            }
            $out[$idEval]['dimensiones'][$idDim]['indicador_desempeno'][] = $indicator;
        }
    }

    // --- Limpieza de mapas internos y conversión a arrays indexados ---
    foreach ($out as &$eval) {
        // subdimensiones: mapa → array
        foreach ($eval['dimensiones'] as &$dim) {
            // limpia mapas de deduplicación internos
            unset($dim['_seen_no_sub']);

            foreach ($dim['subdimensiones'] as &$sub) {
                unset($sub['_seen']);
            }
            unset($sub);

            // ordenar opcionalmente indicadores por nombre
            if (!empty($dim['indicador_desempeno'])) {
                usort($dim['indicador_desempeno'], function ($a, $b) {
                    return ($a['nombre_indicador_desempeno'] ?? '') <=> ($b['nombre_indicador_desempeno'] ?? '');
                });
            }
            // ordenar indicadores dentro de cada subdimensión
            if (!empty($dim['subdimensiones'])) {
                foreach ($dim['subdimensiones'] as &$sub) {
                    if (!empty($sub['indicador_desempeno'])) {
                        usort($sub['indicador_desempeno'], function ($a, $b) {
                            return ($a['nombre_indicador_desempeno'] ?? '') <=> ($b['nombre_indicador_desempeno'] ?? '');
                        });
                    }
                }
                unset($sub);
            }

            // convierte subdimensiones a array indexado
            $dim['subdimensiones'] = array_values($dim['subdimensiones']);
        }
        unset($dim);

        // convierte dimensiones a array indexado
        $eval['dimensiones'] = array_values($eval['dimensiones']);
    }
    unset($eval);

    // resultado final: array indexado por evaluaciones
    return array_values($out);
}



    private function formateaPlantillas($data){
        $grouped = [];

        foreach ($data as $row) {
            // clave de agrupación estable
            $key = implode('|', [
                (string)($row['id_plantilla'] ?? ''),
                (string)($row['nombre_plantilla'] ?? ''),
                (string)($row['descripcion_plantilla'] ?? ''),
                (string)($row['id_tipo_organizacion'] ?? ''),
                (string)($row['tipo_organizacion'] ?? ''),
                (string)($row['id_tipo_plantilla'] ?? ''),
                (string)($row['tipo_plantilla'] ?? '')
            ]);

            if (!isset($grouped[$key])) {
                $grouped[$key] = [
                    'id_plantilla'      => $row['id_plantilla'] ?? null,
                    'nombre_plantilla'      => $row['nombre_plantilla'] ?? null,
                    'descripcion_plantilla'       => $row['descripcion_plantilla'] ?? null,
                    'id_tipo_organizacion'    => $row['id_tipo_organizacion'] ?? null,
                    'tipo_organizacion'    => $row['tipo_organizacion'] ?? null,
                    'id_tipo_plantilla'    => $row['id_tipo_plantilla'] ?? null,
                    'tipo_plantilla'=> $row['tipo_plantilla'] ?? null,
                    'dimensiones'=> [] // <— con ñ, preservado en UTF-8
                ];
            }

            // arma cada indicador con los campos que quieres mostrar
            $indicator = [];
            if (array_key_exists('id_dimension', $row)) {
                $indicator['id_dimension'] = $row['id_dimension'];
            }
            if (array_key_exists('nombre_dimension', $row)) {
                $indicator['nombre_dimension'] = $row['nombre_dimension'];
            }

            $grouped[$key]['dimensiones'][] = $indicator;
        }

        $output = array_values($grouped);
        return $output;
    }
    private function formateaResumen($data){
        // Orden deseado de estados
        $order = ["TOTAL", "ACTIVO", "INACTIVO", "BLOQUEADO"];

        // 1) Agrupar por tipo
        $grouped = [];
        foreach ($data as $row) {
            $tipo   = $row['tipo'];
            $estado = $row['estado'];
            $total  = (int)$row['total'];
        
            if (!isset($grouped[$tipo])) {
                $grouped[$tipo] = [];
            }
            // guardamos por estado para poder ordenar después
            $grouped[$tipo][$estado] = ['estado' => $estado, 'total' => $total];
        }

        // 2) Construir salida con estructura requerida y orden de estados
        $output = [];
        foreach ($grouped as $tipo => $estadosMap) {
            $detalle = [];
        
            // respetar el orden predefinido; incluir solo los estados presentes
            foreach ($order as $estadoDeseado) {
                if (isset($estadosMap[$estadoDeseado])) {
                    $detalle[] = $estadosMap[$estadoDeseado];
                }
            }
        
            // por si aparece algún estado no previsto en $order
            foreach ($estadosMap as $estado => $item) {
                if (!in_array($estado, $order, true)) {
                    $detalle[] = $item;
                }
            }
        
            $output[] = [
                'area'    => $tipo,
                'detalle' => $detalle
            ];
        }
        return $output;
    }
}