<?php
function validateProcess($validationRules,$data){
        $errors = [];
    
    foreach ($validationRules as $field => $rule) {
        $isNull = $rule['isNull'] ?? false;
        // Verificar si el campo es obligatorio
        if ($rule['required'] && !isset($data[$field])) {
            $errors[] = "Field '$field' is required";
            continue;
        }
        // Si el campo no está presente y no es obligatorio, continuar
        if (!isset($data[$field]) && !$rule['required']) {
            continue;
        }
        // Verificar si el campo puede estar vacio
        if ($rule['notEmpty'] && $data[$field]==""){
            $errors[] = "Field '$field' must not be empty";
            continue;
        }
        if(isset($rule['isStatus']) && $rule['isStatus'] == true && !($data[$field] === "ACTIVO" || $data[$field] === "INACTIVO" || $data[$field] === "BLOQUEADO")){
            $errors[] = "Field '$field' accepts only ACTIVO, INACTIVO OR BLOQUEADO values";
            continue;
        }
        if(isset($rule['isFlag']) && $rule['isFlag'] == true && !($data[$field] === "true" || $data[$field] === "false")){
            $errors[] = "Field '$field' accepts only true OR false values";
            continue;
        }
        $value = $data[$field];
        
        // Validar tipo de dato
        switch ($rule['type']) {
            case 'string':
                if (!is_string($value)) $errors[] = "Field '$field' must be a string";
                if (isset($rule['max_length']) && strlen($value) > $rule['max_length']) $errors[] = "Field '$field' exceeds maximum length of {$rule['max_length']}";
                break;
            case 'integer':
                if ($isNull && $value == null) break;
                if (!is_numeric($value) || floor($value) != $value) $errors[] = "Field '$field' must be an integer";
                if (isset($rule['min']) && $value < $rule['min']) $errors[] = "Field '$field' must be at least {$rule['min']}";
                if (isset($rule['max']) && $value > $rule['max']) $errors[] = "Field '$field' must not exceed {$rule['max']}";
                break;
            case 'email':
                if (!filter_var($value, FILTER_VALIDATE_EMAIL)) $errors[] = "Field '$field' must be a valid email address";
                break;
            case 'boolean':
                if (!is_bool($value) && $value !== 0 && $value !== 1) $errors[] = "Field '$field' must be a boolean";
                break;
            case 'datetime':
                $format = 'Y-m-d H:i:s';
                $dateTime = DateTime::createFromFormat($format, $value);
                if (!$dateTime || $dateTime->format($format) !== $value) $errors[] = "Field '$field' must be a valid datetime (YYYY-MM-DD HH:MM:SS)";
                break;
            case 'date':
                $format = 'Y-m-d';
                $dateTime = DateTime::createFromFormat($format, $value);
                if (!$dateTime || $dateTime->format($format) !== $value) $errors[] = "Field '$field' must be a valid datetime (YYYY-MM-DD)";
                break;
        }
    
    }
    return $errors;
}
class ValidateData{
    public static function validarCreacionPuesto($data){
        $validationRules = [
            'puesto' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
                'max_length' => 100
            ],
            'descripcion' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false
            ]            
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
    public static function validarCreacionDepartamento($data){
        $validationRules = [
            'departamento' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
                'max_length' => 50
            ],
            'id_departamento_superior' => [
                'type' => 'string',
                'notEmpty' => false,
                'required' => false,
                'isStatus' => false
            ],          
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
    public static function validarCreacionColaborador($data){
        $validationRules = [
            'rut' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => true,
                'min' => 100000,
                'max' => 99999999
            ],
            'dv' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 1
            ],
            'nombre' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 100
            ],
            'apellido_1' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 100
            ],
            'apellido_2' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 100
            ],
            'email' => [
                'type' => 'email',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false,
                'max_length' => 254
            ],
            'id_departamento' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false
            ],
            'id_jefe' => [
                'type' => 'integer',
                'notEmpty' => false,
                'required' => false,
                'isStatus' => false
            ],
            'id_puesto' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false
            ],
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
    public static function validarActualizacionColaborador($data){
        $validationRules = [
            'rut' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => false,
                'min' => 100000,
                'max' => 99999999
            ],
            'dv' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'max_length' => 1
            ],
            'nombre' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'max_length' => 100
            ],
            'apellido_1' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'max_length' => 100
            ],
            'apellido_2' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'max_length' => 100
            ],
            'email' => [
                'type' => 'email',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false,
                'max_length' => 254
            ],
            'id_departamento' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false
            ],
            'id_jefe' => [
                'type' => 'integer',
                'notEmpty' => false,
                'required' => false,
                'isStatus' => false
            ],
            'id_puesto' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false
            ],
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
    public static function validarBloqueoColaborador($data){
        $validationRules = [
            'bloqueo' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'isFlag' => true,
            ]
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
    public static function validarlistarColaborador($data){
        $validationRules = [
            'estado' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'isFlag' => false,
            ],
            'id_departamento' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => false,
                'isFlag' => false,
            ],
            'id_puesto' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => false,
                'isFlag' => false,
            ],
            'offset' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => true,
                'isFlag' => false,
            ],
            'limit' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => true,
                'isFlag' => false,
            ],
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
    public static function validarActualizarPuesto($data){
        $validationRules = [
            'nombre' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'isFlag' => false,
            ],
            'descripcion' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'isFlag' => false,
            ]
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
    public static function validarActualizarDepartamento($data){
        $validationRules = [
            'nombre' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'isFlag' => false,
            ],
            'id_departamento_padre' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => false,
                'isFlag' => false,
                'isNull' => false
            ]
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
}

?>