<?php
class ErrorDictionary {
    public static function getErrorStructure($errorCode,$errorMessage = NULL,$data = NULL){
        $errors = [
            'E400' => [
                "statusCode" => 400,
                "code" => 'E400',
                "message" => 'Error en los parametros de la llamada',
                "type" => 'error',
                "errors" => $errorMessage,
                "data" => $data
            ],
            'E401' => [
                "statusCode" => 401,
                "code" => 'E401',
                "message" => 'Usuario no autorizado',
                "type" => 'error',
                "errors" => 'Usuario no tiene permitido acceder a este servicio',
                "data" => $data
            ],
            'E402' => [
                "statusCode" => 404,
                "code" => 'E002',
                "message" => 'Recurso No encontrado',
                "type" => 'error',
                "errors" => $errorMessage,
                "data" => $data
            ],
            'E404' => [
                "statusCode" => 404,
                "code" => 'E404',
                "message" => 'Error al procesar la solicitud',
                "type" => 'error',
                "errors" => 'datos solicitados no encontrados',
                "data" => $data
            ],
            'E405' => [
                "statusCode" => 405,
                "code" => 'E405',
                "message" => 'Método no permitido',
                "type" => 'error',
                "errors" => 'Método no permitido',
                "data" => $data
            ],
            'E406' => [
                "statusCode" => 404,
                "code" => 'E406',
                "message" => 'No se realizaron modificaciones al registro',
                "type" => 'error',
                "errors" => 'Registro sin cambio o no encontrado',
                "data" => $data
            ],
            'E500' => [
                "statusCode" => 500,
                "code" => 'E500',
                "message" => 'Error al procesar la solicitud',
                "type" => 'error',
                "errors" => 'Internal server error',
                "data" => $data
            ],
            'E501' => [
                "statusCode" => 500,
                "code" => 'E501',
                "message" => 'Error al procesar la solicitud',
                "type" => 'error',
                "errors" => 'Internal server error in prepare consulting stage',
                "data" => $data
            ],
            'E502' => [
                "statusCode" => 500,
                "code" => 'E502',
                "message" => 'Error al actualizar el registro',
                "type" => 'error',
                "errors" => 'Internal server error in update stage',
                "data" => $data
            ],
            'E503' => [
                "statusCode" => 500,
                "code" => 'E503',
                "message" => 'Error al crear el registro',
                "type" => 'error',
                "errors" => 'Internal server error in create stage',
                "data" => $data
            ],
            'E504' => [
                "statusCode" => 500,
                "code" => 'E504',
                "message" => 'Error al eliminar el registro',
                "type" => 'error',
                "errors" => 'Internal server error in delete stage',
                "data" => $data
            ],
            'E505' => [
                "statusCode" => 500,
                "code" => 'E505',
                "message" => 'Error al crear el registro, no se pueden generar registros duplicados',
                "type" => 'error',
                "errors" => 'Internal server error in create stage',
                "data" => $data
            ]
        ];
        return $errors[$errorCode] ?? [
            "statusCode" => 500,
            "code" => 'E-999',
            "message" => 'Error desconocido en el sistema, por favor intente mas tarde',
            "type" => 'error',
            "errors" => 'Internal server error: '.$errorCode,
            "data" => $data
        ];
    }
    public static function getSuccessStructure($code,$data = NULL,$error = NULL){
        $success = [
            'S001' => [
                "statusCode" => 200,
                "code" => 'S001',
                "message" => 'solicitud procesada con exito',
                "type" => 'success',
                "errors" => $error,
                "data" => $data
            ],
            'S002' => [
                "statusCode" => 201,
                "code" => 'S002',
                "message" => 'Registro creado con exito',
                "type" => 'success',
                "errors" => $error,
                "data" => $data
            ],
            'S003' => [
                "statusCode" => 200,
                "code" => 'S003',
                "message" => 'Registro actualizado con exito',
                "type" => 'success',
                "errors" => $error,
                "data" => $data
            ],
            'S004' => [
                "statusCode" => 200,
                "code" => 'S004',
                "message" => 'Registro eliminado con exito',
                "type" => 'success',
                "errors" => $error,
                "data" => $data
            ],
            'S005' => [
                "statusCode" => 200,
                "code" => 'S003',
                "message" => 'No se han realizado cambios al registro',
                "type" => 'success',
                "errors" => $error,
                "data" => $data
            ]
        ];
        return $success[$code] ?? [
            "statusCode" => 200,
            "code" => 'S000',
            "message" => 'Solicitud procesada exitosamente',
            "type" => 'success',
            "errors" => $error,
            "data" => $data
        ];
    }
}

?>