<?php
require_once 'controllers/OrganizacionController.php';
require_once 'utils/ValidateFieldRule.php';

class Router {
    private $controller;
    private $method;
    private $uri;
    private $id;
    private $typeResource;
    private $header;

    public function __construct($mysqli,$header) {
        $this->method = $_SERVER['REQUEST_METHOD'];
        $this->uri = $_SERVER['REQUEST_URI'];
        $partes = array_filter(explode('/', rtrim($this->uri, '/')));
        $resource = isset($partes[3]) ? $partes[3] : '';
        $this->typeResource = $resource;
        $this->id = isset($partes[4]) && is_numeric($partes[4]) ? (int)$partes[4] : null;
        $this->controller = new OrganizacionController($mysqli,$header);
        $this->header = $header;
    }

    public function route() {
        switch ($this->method) {
            case 'GET':
                if($this->header['User-Id'] == '31') ApiResponse::success('S001',[]);
                switch($this->typeResource){
                    case 'listar-departamentos-empresa':
                        $this->controller->listarDepartamentosEmpresa();
                        break;
                    case 'listar-puestos-empresa':
                        $this->controller->listarPuestosEmpresa();
                        break;
                    case 'obtener-estructura-organizacional':
                        $this->controller->estructuraDepartamentosEmpresa();
                        break;
                    default:
                        ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            case 'POST':
                $input = file_get_contents('php://input');
                $data = json_decode($input, true);
                if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                switch ($this->typeResource) {
                    case 'crear-puesto-empresa':
                        if($error = ValidateData::validarCreacionPuesto($data)) ApiResponse::error('E400',$error);
                        $this->controller->crearPuestoEmpresa($data);
                        break;
                    case 'crear-departamento-empresa':
                        if($error = ValidateData::validarCreacionDepartamento($data)) ApiResponse::error('E400',$error);
                        $this->controller->crearDepartamentoEmpresa($data);
                        break;
                    case 'crear-colaborador-empresa':
                        if($error = ValidateData::validarCreacionColaborador($data)) ApiResponse::error('E400',$error);
                        $this->controller->crearColaboradorEmpresa($data);
                        break;
                    case 'listar-colaborador-empresa':
                        if($error = ValidateData::validarlistarColaborador($data)) ApiResponse::error('E400',$error);
                        $this->controller->listarColaboradoresEmpresa($data);
                        break;
                    default:
                        ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }               
                break;
            case 'PATCH':
                if($this->header['User-Id'] == '31') ApiResponse::error('E404');
                if(!$this->id)ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                switch ($this->typeResource) {
                    case 'actualizar-colaborador-empresa':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateData::validarActualizacionColaborador($data)) ApiResponse::error('E400',$error);
                        $this->controller->actualizarColaboradorEmpresa($data,$this->id);
                        break;
                    case 'bloquear-colaborador-empresa':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateData::validarBloqueoColaborador($data)) ApiResponse::error('E400',$error);
                        $this->controller->bloqueaColaboradorEmpresa($data,$this->id);
                        break;
                    case 'actualizar-puesto-empresa':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateData::validarActualizarPuesto($data)) ApiResponse::error('E400',$error);
                        $this->controller->actualizarPuestoTrabajoEmpresa($data,$this->id);
                        break;
                    case 'actualizar-departamento-empresa':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateData::validarActualizarDepartamento($data)) ApiResponse::error('E400',$error);
                        $this->controller->actualizarDepartamentoEmpresa($data,$this->id);
                        break;
                    case 'bloquear-empresa':
                        $this->controller->bloquearEmpresa($this->id);
                        break;
                    default:
                        ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            case 'DELETE':
                if(!$this->id)ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                switch ($this->typeResource) {
                    case 'eliminar-colaborador-empresa':
                        $this->controller->eliminaColaboradorEmpresa($this->id);
                        break;
                    case 'eliminar-puesto-empresa':
                        $this->controller->eliminarPuestoTrabajoEmpresa($this->id);
                        break;
                    case 'eliminar-departamento-empresa':
                        $this->controller->eliminarDepartamentoEmpresa($this->id);
                        break;
                    default:
                        ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            default:
                ApiResponse::error('E405');
                break;
        }
    }
}
?>