<?php
require_once __DIR__ .'/../utils/ErrorDictionary.php';
function send($response) {
    http_response_code($response['statusCode']);
    header('Content-Type: application/json; charset=UTF-8');
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit;
}
class ApiResponse {
    public static function success($successCode,$data = NULL,$error = NULL) {
        $successData = ErrorDictionary::getSuccessStructure($successCode,$data,$error);
        send($successData);
    }
    public static function error($errorCode,$errorMessage = NULL) {
        $errorData = ErrorDictionary::getErrorStructure($errorCode,$errorMessage);
        send($errorData);
    }
}