<?php
require 'vendor/autoload.php';
//$config = require __DIR__ . '/../config/database.php';
//var_dump($config);
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

class Login{
    private $mysqli;
    private $config;
    public function __construct($mysqli,$config) {
        $this->mysqli = $mysqli;
        $this->mysqli->set_charset("utf8mb4");
        $this->config = $config;
    }
    public function resetCountError($id){
        $sql = "UPDATE __usuarios SET cantidad_error = 0
             WHERE id = ?;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception ('E006');
        }
        $stmt->bind_param("i", $id);
        $stmt->execute();
        
        if (!$stmt->execute()) {
            throw new Exception('E007');
        }
        $stmt->close();
    }
    public function addErrorCount($id){
        $sql = "UPDATE __usuarios SET cantidad_error = cantidad_error + 1, estado = CASE 
                WHEN cantidad_error >= 3 THEN 'BLOQUEADO' 
                ELSE estado 
             END , fecha_bloqueo = case WHEN cantidad_error >= 3 THEN now() 
                ELSE fecha_bloqueo 
             END
             WHERE id = ?;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception ('E006');
        }
        $stmt->bind_param("i", $id);
        if (!$stmt->execute()) {
            throw new Exception('E007');
        }
        $stmt->close();
    }
    public function generateJWT($user,$sessionCode){
        $role = $user['perfil'];
        $iat = time();
        $exp = time() + 3600;
        $iss = 'https://rubritest.cl';
        $payload = [
            'sub' => ''.$user['id'],
            'sessionCode'=> ''.$sessionCode,
            'role'=> ''.$role,
            'iat' => $iat,
            'exp' => $exp,
            'iss' => $iss
        ];
        if(!$jwt = JWT::encode($payload,$this->config['jwt_secret'], 'HS256')) throw new Exception ('Error en el proceso');
        //almacena registro de la sesión creada
        $paramLogin = "insert into __sessionregister(sessionCode,sub,iat,exp,iss,role) values(?,?,?,?,?,?);";
        $stmt = $this->mysqli->prepare($paramLogin);
        if ($stmt === false) {
            throw new Exception ('E006');
        }
        $stmt->bind_param("ssiiss", $sessionCode,$user['id'], $iat, $exp, $iss, $role);
        if($stmt->execute()){
            $response = array(
                'sessionCode' => $sessionCode,
                'accessToken' => $jwt,
                'nombre'=> $user['nombre'],
                'apellido_1' => $user['apellido_1'],
                'apellido_2' => $user['apellido_2'],
                'email' => $user['email'],
                'id' => $user['id'],
                'bussinesId' => $user['id_empresa'],
                'profile' => $user['perfil']
            );
            return $response;
        }else{
            throw new Exception ('E007');
        }
    }
    public function login($usuario){
        $sql = "SELECT u.id,u.nombre,u.apellido_1,u.apellido_2,u.contrasena,u.hash_auth,u.email,u.id_empresa,u.estado,u.cantidad_error,p.tipo AS perfil from __usuarios u LEFT JOIN __usuario_perfil up ON u.id = up.id_usuario LEFT JOIN __perfil p ON up.id_perfil = p.id where u.nombre_usuario COLLATE utf8mb4_bin =  ? and u.estado IN ('ACTIVO','BLOQUEADO') ";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception ('E006');
        }
        $stmt->bind_param("s", $usuario);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();
        $stmt->close();
        return $user;
    }
    public function searchUser($usuario){
        $sql = "SELECT id, concat(nombre,' ',apellido_1) as nombre, email from __usuarios where nombre_usuario COLLATE utf8mb4_bin =  ? and estado IN ('ACTIVO','BLOQUEADO') ";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception ('E006');
        }
        $stmt->bind_param("s", $usuario);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();
        $stmt->close();
        return $user;
    }
    public function registraOtp($identificador,$otp,$creacion,$expiracion,$idUsuario){
        $sql = "insert into __otp_loger (uuid,fecha_creacion,fecha_expiracion,valor_otp,tipo,estado,id_user) value(?,?,?,?,?,?,?);";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception ('E006');
        }
        $tipoOTP = "RESET PASWORD";
        $status = "ACTIVO";
        $stmt->bind_param("sssissi", $identificador, $creacion, $expiracion, $otp, $tipoOTP, $status, $idUsuario);
        if($stmt->execute()){
            return true;
        }else{
            throw new Exception ('E007');
        }
    }
    public function search_otp($identificador){
        $sql = "SELECT o.uuid as identificador, o.fecha_creacion, o.fecha_expiracion, o.valor_otp as otp, o.tipo, o.estado, o.intentos, o.id_user,o.session_code, u.email, u.nombre_usuario from __otp_loger o left join __usuarios u ON o.id_user = u.id where uuid=? and tipo = ?;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception ('E006');
        }
        $tipoOTP = "RESET PASWORD";
        $stmt->bind_param("ss", $identificador,$tipoOTP);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();
        $stmt->close();
        return $user; 
    }
    public function addOtpErrorCount($identificador){
        $sql = "UPDATE __otp_loger SET intentos = intentos + 1, estado = CASE 
                WHEN intentos >= 3 THEN 'BLOQUEADO' 
                ELSE estado 
             END
             WHERE uuid = ?;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception ('E006');
        }
        $stmt->bind_param("s", $identificador);
        if (!$stmt->execute()) {
            throw new Exception('E007');
        }
        $stmt->close();
    }
    public function saveSessionCode($identificador,$sessionCode){
        $sql = "update __otp_loger set session_code = ? , estado = ? where uuid = ?;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception ('E006');
        }
        $estado = "VALIDADA";
        $stmt->bind_param("sss", $sessionCode,$estado,$identificador);
        //$stmt->execute();
        if (!$stmt->execute()) {
            throw new Exception('E007');
        }
        $stmt->close();
    }
    public function changePassword($id,$contrasena,$hash_auth){
         $sql = "UPDATE __usuarios SET contrasena = ? , hash_auth = ? , estado = 'ACTIVO', fecha_ultimo_cambio = now(), fecha_bloqueo = NULL   WHERE id = ?;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception ('E006');
        }
        $stmt->bind_param("ssi", $contrasena,$hash_auth,$id);
        
        if (!$stmt->execute()) {
            throw new Exception('E007');
        }
        $affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $affected_rows;
    }
}