<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
require 'vendor/autoload.php';
require_once 'utils/ApiResponse.php';
require_once 'routes/api.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Configurar zona horaria
date_default_timezone_set('America/Caracas');
// Conexión a la base de datos
$config = require __DIR__ . '/config/database.php';
try{
    $mysqli = new mysqli($config['host'], $config['usuario'], $config['contrasena'], $config['base_datos']);
    if ($mysqli->connect_error) {
        throw new Exception('error al conectar a Base de datos');
    }
}catch (Exception $e){
    ApiResponse::error($e->getMessage());
}

// Validar token JWT
$headers = getallheaders();
// Inicializar y ejecutar el enrutador
$router = new Router($mysqli,$config);
$router->route();
// Cerrar conexión
$mysqli->close();
?>