<?php
require_once __DIR__ .'/../models/Login.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

function generateUuidV4(): string {
    $data = random_bytes(16);
    $data[6] = chr(ord($data[6]) & 0x0f | 0x40); // Establecer versión 4
    $data[8] = chr(ord($data[8]) & 0x3f | 0x80); // Establecer variante
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}

class LoginController{
    private $loginModel;
    private $dataErrors = [];
    private $config;

    public function __construct($mysqli,$config){
        $this->loginModel = new Login($mysqli,$config);
        $this->config = $config;
    }

    public function login($data){
        try{
            $user = $this->loginModel->login($data['usuario']);
            if($user){
                if($user['estado']=='BLOQUEADO') throw new Exception ('E002');
                if($user['estado']=='ACTIVO'){
                    if($user['hash_auth'] === $data['contrasena']){
                        $sessionCode = generateUuidV4();
                        $accesstoken = $this->loginModel->generateJWT($user,$sessionCode);
                        if($accesstoken){
                            $this->loginModel->resetCountError($user['id']);
                            ApiResponse::success('S001',$accesstoken);
                        }
                    }
                    $this->loginModel->addErrorCount($user['id']);
                    if($user['cantidad_error'] == 0) throw new Exception ("E003");
                    if($user['cantidad_error'] == 1) throw new Exception ("E004");
                    if($user['cantidad_error'] == 2) throw new Exception ("E005");
                }
            }else{
                throw new Exception("E001");
            }
        }catch (Exception $e){
            ApiResponse::error($e->getMessage());
        }
    }
    public function send_email($data){
        try {
            $user = $this->loginModel->searchUser($data['usuario']);
            if($user){
                if($user['email'] == $data['email']){
                    $otp = rand(100000,999999);
                    $creacion = time();
                    $expiracion = time() + 900;
                    $identificador = generateUuidV4();
                    if($this->loginModel->registraOtp($identificador,$otp,$creacion,$expiracion,$user['id'])){
                        try{
                            $asunto = "Recuparación de contraseña Bethprof";
                            $mensaje = "<h1>".$user['nombre']."</h1><p>Tu OTP para reestablecer tu contraseña BethProf es: <strong>".$otp."</strong> la cual tiene una vigencia de 15 minutos</p>";
                            $mail = new PHPMailer(true);
                            $mail->SMTPDebug = 0;
                            $mail->isSMTP();
                            $mail->Host = $this->config['email_host']; // Cambia esto por tu servidor SMTP
                            $mail->SMTPAuth = true;
                            $mail->Username = $this->config['email']; // Tu usuario SMTP
                            $mail->Password = $this->config['email_pass']; // Tu contraseña SMTP
                            $mail->SMTPSecure = 'ssl';
                            $mail->Port = 465; // Puerto TCP para conectar
                            $mail->CharSet = 'utf8mb4';
                            
                            // Remitente y destinatario
                            $mail->setFrom($this->config['email'], 'BethProf');
                            $mail->addAddress($user['email']);

                            // Contenido del correo
                            $mail->isHTML(true);
                            $mail->Subject = $asunto;
                            $mail->Body = $mensaje;
                            $mail->AltBody = strip_tags($mensaje); // Versión en texto plano

                            $mail->send();

                            $datosRespuesta = array(
                                    'identificador' => $identificador,
                                    'estadoOTP' => 'Enviado',
                                    'nombre_cliente'=> $user['nombre'],
                                    'vigencia' => gmdate("Y-m-d H:i:s", $expiracion),
                                );
                            ApiResponse::success('S001',$datosRespuesta);
                        }catch (Exception $e) {
                            ApiResponse::error($mail->ErrorInfo);
                        }
                    }
                }else{
                    throw new Exception("E012");
                }
            }else{
                throw new Exception("E001");
            }
        } catch (Exception $e) {
           ApiResponse::error($e->getMessage());
        }
    }
    public function verify_otp($data){
        try {
            $otp = $this->loginModel->search_otp($data['identificador']);
            if($otp){
                if($otp['estado'] == "BLOQUEADO") throw new Exception ('E013');
                if($otp['estado'] == "ACTIVO"){
                    // validar si la otp entregada es distinta a la generada por el sistema
                    if($otp['nombre_usuario'] != $data['usuario']) throw new Exception('E016');
                    if($otp['email'] != $data['email']) throw new Exception('E016');
                    if($otp['otp'] != $data['otp']){
                        $this->loginModel->addOtpErrorCount($data['identificador']);
                        if($otp['intentos'] == 0) throw new Exception ("E014");
                        if($otp['intentos'] == 1) throw new Exception ("E015");
                        if($otp['intentos'] == 2) throw new Exception ("E013");
                    }
                    $horaActual = time();
                    if($horaActual > $otp['fecha_expiracion']){
                        throw new Exception ("E013");
                    }
                    $sessionCode = generateUuidV4();
                    $this->loginModel->saveSessionCode($data['identificador'],$sessionCode);
                    $datosRespuesta = array(
                        "estadoOTP"=>"valida",
                        "sessionCode"=>$sessionCode
                        );

                    ApiResponse::success('S001',$datosRespuesta);
                }
                if($otp['estado'] == "VALIDADA"){
                    $horaActual = time();
                    if($horaActual > $otp['fecha_expiracion']){
                        throw new Exception ("E013");
                    }
                    $datosRespuesta = array(
                        "estadoOTP"=>"valida",
                        "sessionCode"=>$otp['session_code']
                    );
                    ApiResponse::success('S001',$datosRespuesta);
                }
            }
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function change_password($data){
        try{
            $otp = $this->loginModel->search_otp($data['identificador']);
            if($otp){
                if($otp['estado'] == "BLOQUEADO") throw new Exception ('E013');
                if($otp['estado'] == "ACTIVO") throw new Exception ('E016');
                if($otp['estado'] == "VALIDADA"){
                    // validar si la otp entregada es distinta a la generada por el sistema
                    if($otp['nombre_usuario'] != $data['usuario']) $dataErrors[] = "El nombre de usuario provisto no corresponde al proceso en curso";
                    if($otp['email'] != $data['email']) $dataErrors[] = "El email provisto no corresponde al proceso en curso";
                    if($otp['session_code'] != $data['sessionCode']) $dataErrors[] = "El sesionCode provisto no corresponde al proceso en curso";

                    if(isset($data['contrasena']) && isset($data['hash_auth'])){
                        $hashCalculado = hash('sha256', $data['contrasena']);
                        if ($hashCalculado != $data['hash_auth']) $dataErrors[] = "EL hash_auth provisto no es valido";
                    }
                    if(isset($dataErrors)) ApiResponse::error('E008',$dataErrors);

                    $affected_rows = $this->loginModel->changePassword($otp['id_user'],$data['contrasena'],$data['hash_auth']);
                    if ($affected_rows > 0) ApiResponse::success('S004'); throw new Exception('E007');
                }
            }
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
}