<?php
class Evaluacion {
    private $mysqli;
    private $header;

    public function __construct($mysqli,$header) {
        $this->mysqli = $mysqli;
        $this->mysqli->set_charset("utf8mb4");
        $this->header = $header;
    }
    /* EVALUACION DE DESEMPEÑO 
    funciones de creacion de evaluaciones de desempeño*/
    public function crearEvaluacion($data){
        $sql = "insert into __rol(nombre,descripcion,id_empresa,id_usuario_creador,id_usuario_asignado ) values (?,?,?,?,?)";
        $types = 'ssiii';
        $values = array($data['nombre'],$data['descripcion'],$this->header['Business-Id'],$this->header['User-Id'],$this->header['User-Id']);
        $resp = $this->executeInsertQuery($sql,$types,$values);
        return $resp;
    }
    public function crearDimension($data){
        $sql = "insert into __rol_dimension(nombre,id_rol) values (?,?)";
        $types = 'si';
        $values = array($data['nombre'],$data['id_evaluacion']);
        $resp = $this->executeInsertQuery($sql,$types,$values);
        return $resp;
    }
    public function crearSubdimension($data){
        $sql = "insert into __rol_subdimension(nombre,id_dimension,id_rol) values (?,?,?)";
        $types = 'sii';
        $values = array($data['nombre'],$data['id_dimension'],$data['id_evaluacion']);
        $resp = $this->executeInsertQuery($sql,$types,$values);
        return $resp;
    }
    public function crearIndicadorDesempeno($data){
        $sql = "insert into __rol_indicador_desempeno(nombre,id_dimension,id_subdimension,id_rol) values (?,?,?,?)";
        $types = 'siii';
        $values = array($data['nombre'],$data['id_dimension'],$data['id_subdimension'] ?? null,$data['id_evaluacion']);
        $resp = $this->executeInsertQuery($sql,$types,$values);
        return $resp;
    }   
    /* funciones de obtencion de datos de evaluaciones de desempeño*/
    public function obtenerEvaluacionByIdUserRH($id){
        $sql = "SELECT _r.id AS id_evaluacion
            ,_r.nombre
            ,_r.descripcion
            ,_r.estado
            ,_r.fecha_creacion
            ,_e.id AS id_empresa
            ,_e.nombre AS nombre_empresa
            ,_u.id AS id_usuario_asignado
            ,CONCAT_WS(' ',_u.nombre,_u.apellido_1,_u.apellido_2) AS nombre_usuario_asignado
            FROM __rol _r 
            LEFT JOIN __empresa _e ON _e.id = _r.id_empresa
            LEFT JOIN __usuarios _u ON _u.id = _r.id_usuario_asignado
            WHERE _r.id = ? 
                AND _r.id_empresa = ? 
                AND _r.id_usuario_asignado = ? 
                AND _r.estado = ?
            ;";
        $types = 'iiis';
        $values = array($id,$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerEvaluacionByIdAdmin($id){
        $sql = "SELECT _r.id AS id_evaluacion
            ,_r.nombre
            ,_r.descripcion
            ,_r.estado
            ,_r.fecha_creacion
            ,_e.id AS id_empresa
            ,_e.nombre AS nombre_empresa
            ,_u.id AS id_usuario_asignado
            ,CONCAT_WS(' ',_u.nombre,_u.apellido_1,_u.apellido_2) AS nombre_usuario_asignado
            FROM __rol _r 
            LEFT JOIN __empresa _e ON _e.id = _r.id_empresa
            LEFT JOIN __usuarios _u ON _u.id = _r.id_usuario_asignado
            WHERE _r.id = ? 
                AND _r.id_empresa = ?
                AND _r.estado = ?
            ;";
        $types = 'iis';
        $values = array($id,$this->header['Business-Id'],"ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerEvaluacionByIdSuperadmin($id){
        $sql = "SELECT _r.id AS id_evaluacion
            ,_r.nombre
            ,_r.descripcion
            ,_r.estado
            ,_r.fecha_creacion
            ,_e.id AS id_empresa
            ,_e.nombre AS nombre_empresa
            ,_u.id AS id_usuario_asignado
            ,CONCAT_WS(' ',_u.nombre,_u.apellido_1,_u.apellido_2) AS nombre_usuario_asignado
            FROM __rol _r 
            LEFT JOIN __empresa _e ON _e.id = _r.id_empresa
            LEFT JOIN __usuarios _u ON _u.id = _r.id_usuario_asignado
            WHERE _r.id = ? 
                AND _r.estado = ?
            ;";
        $types = 'is';
        $values = array($id,"ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerEvaluacionUserRH(){
        $sql = "SELECT _r.id AS id_evaluacion
            ,_r.nombre
            ,_r.descripcion
            ,_r.estado
            ,_r.fecha_creacion
            ,_e.id AS id_empresa
            ,_e.nombre AS nombre_empresa
            ,_u.id AS id_usuario_asignado
            ,CONCAT_WS(' ',_u.nombre,_u.apellido_1,_u.apellido_2) AS nombre_usuario_asignado
            FROM __rol _r 
            LEFT JOIN __empresa _e ON _e.id = _r.id_empresa
            LEFT JOIN __usuarios _u ON _u.id = _r.id_usuario_asignado
            WHERE _r.id_empresa = ? 
                AND _r.id_usuario_asignado = ?
                AND _r.estado = ?
            ;";
        $types = 'iis';
        $values = array($this->header['Business-Id'],$this->header['User-Id'],"ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerEvaluacionAdmin(){
        $sql = "SELECT _r.id AS id_evaluacion
            ,_r.nombre
            ,_r.descripcion
            ,_r.estado
            ,_r.fecha_creacion
            ,_e.id AS id_empresa
            ,_e.nombre AS nombre_empresa
            ,_u.id AS id_usuario_asignado
            ,CONCAT_WS(' ',_u.nombre,_u.apellido_1,_u.apellido_2) AS nombre_usuario_asignado
            FROM __rol _r 
            LEFT JOIN __empresa _e ON _e.id = _r.id_empresa
            LEFT JOIN __usuarios _u ON _u.id = _r.id_usuario_asignado
            WHERE _r.id_empresa = ?
                AND _r.estado = ?
            ";
        $types = 'is';
        $values = array($this->header['Business-Id'],"ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerEvaluacion_indicadorDesempenobyId($id){
        $sql = "SELECT _r.id_empresa
            ,_r.id_usuario_asignado
            ,_r.estado 
            FROM __rol_indicador_desempeno AS _rid
            LEFT JOIN __rol AS _r ON _r.id = _rid.id_rol
            WHERE _rid.id = ?
            ;";
        $types = 'i';
        $values = array($id);
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerEvaluacion_dimensionbyId($id){
        $sql = "SELECT _r.id_empresa
            ,_r.id_usuario_asignado
            ,_r.estado 
            FROM __rol_dimension AS _rd
            LEFT JOIN __rol AS _r ON _r.id = _rd.id_rol
            WHERE _rd.id = ?
            ;";
        $types = 'i';
        $values = array($id);
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerEvaluacion_subdimensionbyId($id){
        $sql = "SELECT _r.id_empresa
            ,_r.id_usuario_asignado
            ,_r.estado 
            FROM __rol_subdimension AS _rs
            LEFT JOIN __rol AS _r ON _r.id = _rs.id_rol
            WHERE _rs.id = ?
            ;";
        $types = 'i';
        $values = array($id);
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerEvaluacionSuperadmin(){
        $sql = "SELECT _r.id AS id_evaluacion
            ,_r.nombre
            ,_r.descripcion
            ,_r.estado
            ,_r.fecha_creacion
            ,_e.id AS id_empresa
            ,_e.nombre AS nombre_empresa
            ,_u.id AS id_usuario_asignado
            ,CONCAT_WS(' ',_u.nombre,_u.apellido_1,_u.apellido_2) AS nombre_usuario_asignado
            FROM __rol _r 
            LEFT JOIN __empresa _e ON _e.id = _r.id_empresa
            LEFT JOIN __usuarios _u ON _u.id = _r.id_usuario_asignado
            WHERE _r.estado = ?
            ;";
        $types = 's';
        $values = array("ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerDimensionByIdUserRH($id){
        $sql = "SELECT _rd.id
            , _rd.nombre
            , _rd.id_rol AS id_evaluacion 
            FROM __rol_dimension _rd 
            LEFT JOIN __rol _r ON _r.id = _rd.id_rol 
            WHERE _rd.id = ? 
                AND _r.id_empresa = ? 
                AND _r.id_usuario_asignado = ?
                AND _r.estado = ?
                AND _rd.estado = ?
            ";
        $types = 'iiiss';
        $values = array($id,$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerDimensionByIdAdmin($id){
        $sql = "SELECT _rd.id
            ,_rd.nombre
            ,_rd.id_rol AS id_evaluacion 
            FROM __rol_dimension _rd 
            LEFT JOIN __rol _r ON _r.id = _rd.id_rol 
            WHERE _rd.id = ? 
                AND _r.id_empresa = ?
                AND _r.estado = ?
                AND _rd.estado = ?
            ;";
        $types = 'iiss';
        $values = array($id,$this->header['Business-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerDimensionByIdSuperAdmin($id){
        $sql = "SELECT _rd.id
            ,_rd.nombre
            ,_rd.id_rol AS id_evaluacion 
            FROM __rol_dimension _rd 
            LEFT JOIN __rol _r ON _r.id = _rd.id_rol 
            WHERE _rd.id = ?
                AND _r.estado = ?
                AND _rd.estado = ?
            ;";
        $types = 'iss';
        $values = array($id,"ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerDimensionesUserRH($data){
        $sql = "SELECT _rd.id
            , _rd.nombre
            ,_rd.id_rol AS id_evaluacion
            FROM __rol_dimension _rd 
            LEFT JOIN __rol _r ON _r.id = _rd.id_rol 
            WHERE _r.id = ? 
                AND _r.id_empresa = ? 
                AND _r.id_usuario_asignado = ?
                AND _r.estado = ?
                AND _rd.estado = ?
            ;";
        $types = 'iiiss';
        $values = array($data['id_evaluacion'],$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerDimensionesAdmin($data){
        $sql = "SELECT _rd.id
            ,_rd.nombre
            ,_rd.id_rol AS id_evaluacion 
            FROM __rol_dimension _rd 
            LEFT JOIN __rol _r ON _r.id = _rd.id_rol 
            WHERE _r.id = ? 
                AND _r.id_empresa = ?
                AND _r.estado = ?
                AND _rd.estado = ?
            ;";
        $types = 'iiss';
        $values = array($data['id_evaluacion'],$this->header['Business-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerDimensionesSuperadmin($data){
        $sql = "SELECT _rd.id
            ,_rd.nombre
            ,_rd.id_rol AS id_evaluacion 
            FROM __rol_dimension _rd 
            LEFT JOIN __rol _r ON _r.id = _rd.id_rol 
            WHERE _r.id = ?
                AND _r.estado = ?
                AND _rd.estado = ?
            ;";
        $types = 'iss';
        $values = array($data['id_evaluacion'],"ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerSubdimensionSuperadmin($data){
        $sql = "select _rs.id
            ,_rs.nombre
            ,_rs.id_dimension
            ,_rs.id_rol AS id_evaluacion 
            from __rol_subdimension _rs
            LEFT JOIN __rol _r ON _r.id = _rs.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rs.id_dimension
            where _rs.id_dimension = ? 
                AND _rs.id_rol = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rs.estado = ?
            ;";
        $types = 'iisss';
        $values = array($data['id_dimension'],$data['id_evaluacion'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerSubdimensionAdmin($data){
        $sql = "select _rs.id
            ,_rs.nombre
            ,_rs.id_dimension
            ,_rs.id_rol AS id_evaluacion 
            from __rol_subdimension _rs
            LEFT JOIN __rol _r ON _r.id = _rs.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rs.id_dimension
            where _rs.id_dimension = ? 
                AND _rs.id_rol = ? 
                AND _r.id_empresa = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rs.estado = ?
            ;";
        $types = 'iiisss';
        $values = array($data['id_dimension'],$data['id_evaluacion'],$this->header['Business-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerSubdimensionUserRH($data){
        $sql = "select _rs.id
            ,_rs.nombre
            ,_rs.id_dimension
            ,_rs.id_rol AS id_evaluacion 
            from __rol_subdimension _rs
            LEFT JOIN __rol _r ON _r.id = _rs.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rs.id_dimension
            where _rs.id_dimension = ? 
                AND _rs.id_rol = ? 
                AND _r.id_empresa = ? 
                AND _r.id_usuario_asignado=?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rs.estado = ?
            ;";
        $types = 'iiiisss';
        $values = array($data['id_dimension'],$data['id_evaluacion'],$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerSubdimensionByIdSuperadmin($id){
        $sql = "select _rs.id
            ,_rs.nombre
            ,_rs.id_dimension
            ,_rs.id_rol AS id_evaluacion 
            from __rol_subdimension _rs
            LEFT JOIN __rol _r ON _r.id = _rs.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rs.id_dimension
            where _rs.id = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rs.estado = ?
            ;";
        $types = 'isss';
        $values = array($id,"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerSubdimensionByIdAdmin($id){
        $sql = "select _rs.id
            ,_rs.nombre
            ,_rs.id_dimension
            ,_rs.id_rol AS id_evaluacion 
            from __rol_subdimension _rs
            LEFT JOIN __rol _r ON _r.id = _rs.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rs.id_dimension
            where _rs.id = ? 
                AND _r.id_empresa = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rs.estado = ?
            ;";
        $types = 'iisss';
        $values = array($id,$this->header['Business-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerSubdimensionByIdUserRH($id){
        $sql = "select _rs.id
            ,_rs.nombre
            ,_rs.id_dimension
            ,_rs.id_rol AS id_evaluacion 
            from __rol_subdimension _rs
            LEFT JOIN __rol _r ON _r.id = _rs.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rs.id_dimension
            where _rs.id = ? 
                AND _r.id_empresa = ? 
                AND _r.id_usuario_asignado = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rs.estado = ?
            ;";
        $types = 'iiisss';
        $values = array($id,$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerSubdimensionById($id){
        $sql = "select _rs.id
            ,_rs.nombre
            ,_rs.id_dimension
            ,_rs.id_rol AS id_evaluacion 
            from __rol_subdimension _rs
            LEFT JOIN __rol _r ON _r.id = _rs.id_rol
            where _rs.id = ?;";
        $types = 'i';
        $values = array($id);
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerIndicadorDesenpenoSuperadmin($data){
        $sql = "SELECT _rid.id AS id_indicador_desempeno
            ,_rid.nombre AS nombre_indicador_desempeno
            ,_rid.id_dimension AS id_dimension
            ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.id_subdimension END AS id_subdimension
	        ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.nombre END AS nombre_subdimension
            ,_rid.id_rol AS id_evaluacion
            FROM __rol_indicador_desempeno _rid 
            LEFT JOIN __rol_subdimension _rs ON _rs.id = _rid.id_subdimension 
            LEFT JOIN __rol _r ON _r.id = _rid.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rid.id_dimension
            WHERE _rid.id_dimension = ? 
                AND _rid.id_rol = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rid.estado = ?
            ORDER BY _rid.id_subdimension desc;";
        $types = 'iisss';
        $values = array($data['id_dimension'],$data['id_evaluacion'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerIndicadorDesenpenoAdmin($data){
        $sql = "SELECT _rid.id AS id_indicador_desempeno
            ,_rid.nombre AS nombre_indicador_desempeno
            ,_rid.id_dimension AS id_dimension
            ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.id_subdimension END AS id_subdimension
	        ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.nombre END AS nombre_subdimension
            ,_rid.id_rol AS id_evaluacion
            FROM __rol_indicador_desempeno _rid 
            LEFT JOIN __rol_subdimension _rs ON _rs.id = _rid.id_subdimension 
            LEFT JOIN __rol _r ON _r.id = _rid.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rid.id_dimension
            WHERE _rid.id_dimension = ? 
                AND _rid.id_rol = ?
                AND _r.id_empresa = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rid.estado = ?
            ORDER BY _rid.id_subdimension desc;";
        $types = 'iiisss';
        $values = array($data['id_dimension'],$data['id_evaluacion'],$this->header['Business-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerIndicadorDesenpenoUserRH($data){
        $sql = "SELECT _rid.id AS id_indicador_desempeno
            ,_rid.nombre AS nombre_indicador_desempeno
            ,_rid.id_dimension AS id_dimension
            ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.id_subdimension END AS id_subdimension
	        ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.nombre END AS nombre_subdimension
            ,_rid.id_rol AS id_evaluacion
            FROM __rol_indicador_desempeno _rid 
            LEFT JOIN __rol_subdimension _rs ON _rs.id = _rid.id_subdimension 
            LEFT JOIN __rol _r ON _r.id = _rid.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rid.id_dimension
            WHERE _rid.id_dimension = ? 
                AND _rid.id_rol = ?
                AND _r.id_empresa = ?
                AND _r.id_usuario_asignado = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rid.estado = ?
            ORDER BY _rid.id_subdimension desc;";
        $types = 'iiiisss';
        $values = array($data['id_dimension'],$data['id_evaluacion'],$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerIndicadorDesenpenoByIdSuperadmin($id){
        $sql = "SELECT _rid.id AS id_indicador_desempeno
            ,_rid.nombre AS nombre_indicador_desempeno
            ,_rid.id_dimension AS id_dimension
            ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.id_subdimension END AS id_subdimension
	        ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.nombre END AS nombre_subdimension
            ,_rid.id_rol AS id_evaluacion
            FROM __rol_indicador_desempeno _rid 
            LEFT JOIN __rol_subdimension _rs ON _rs.id = _rid.id_subdimension 
            LEFT JOIN __rol _r ON _r.id = _rid.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rid.id_dimension
            WHERE _rid.id = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rid.estado = ?
            ORDER BY _rid.id_subdimension desc;";
        $types = 'isss';
        $values = array($id,"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerIndicadorDesenpenoByIdAdmin($id){
        $sql = "SELECT _rid.id AS id_indicador_desempeno
            ,_rid.nombre AS nombre_indicador_desempeno
            ,_rid.id_dimension AS id_dimension
            ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.id_subdimension END AS id_subdimension
	        ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.nombre END AS nombre_subdimension
            ,_rid.id_rol AS id_evaluacion
            FROM __rol_indicador_desempeno _rid 
            LEFT JOIN __rol_subdimension _rs ON _rs.id = _rid.id_subdimension 
            LEFT JOIN __rol _r ON _r.id = _rid.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rid.id_dimension
            WHERE _rid.id = ? 
                AND _r.id_empresa = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rid.estado = ?
            ORDER BY _rid.id_subdimension desc;";
        $types = 'iisss';
        $values = array($id,$this->header['Business-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerIndicadorDesenpenoByIdUserRH($id){
        $sql = "SELECT _rid.id AS id_indicador_desempeno
            ,_rid.nombre AS nombre_indicador_desempeno
            ,_rid.id_dimension AS id_dimension
            ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.id_subdimension END AS id_subdimension
	        ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.nombre END AS nombre_subdimension
            ,_rid.id_rol AS id_evaluacion
            FROM __rol_indicador_desempeno _rid 
            LEFT JOIN __rol_subdimension _rs ON _rs.id = _rid.id_subdimension 
            LEFT JOIN __rol _r ON _r.id = _rid.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rid.id_dimension
            WHERE _rid.id = ?
                AND _r.id_empresa = ?
                AND _r.id_usuario_asignado = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rid.estado = ?
            ORDER BY _rid.id_subdimension desc;";
        $types = 'iiisss';
        $values = array($id,$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerIndicadorDesempenoSubdimensionSuperadmin($data){
        $sql = "SELECT _rid.id AS id_indicador_desempeno
            ,_rid.nombre AS nombre_indicador_desempeno
            ,_rid.id_dimension AS id_dimension
            ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.id_subdimension END AS id_subdimension
	        ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.nombre END AS nombre_subdimension
            ,_rid.id_rol AS id_evaluacion
            FROM __rol_indicador_desempeno _rid 
            LEFT JOIN __rol_subdimension _rs ON _rs.id = _rid.id_subdimension 
            LEFT JOIN __rol _r ON _r.id = _rid.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rid.id_dimension
            WHERE _rid.id_subdimension = ? 
                AND _rid.id_dimension = ? 
                AND _rid.id_rol = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rid.estado = ?
            ORDER BY _rid.id_subdimension desc;";
        $types = 'iiisss';
        $values = array($data['id_subdimension'],$data['id_dimension'],$data['id_evaluacion'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerIndicadorDesempenoSubdimensionAdmin($data){
        $sql = "SELECT _rid.id AS id_indicador_desempeno
            ,_rid.nombre AS nombre_indicador_desempeno
            ,_rid.id_dimension AS id_dimension
            ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.id_subdimension END AS id_subdimension
	        ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.nombre END AS nombre_subdimension
            ,_rid.id_rol AS id_evaluacion
            FROM __rol_indicador_desempeno _rid 
            LEFT JOIN __rol_subdimension _rs ON _rs.id = _rid.id_subdimension 
            LEFT JOIN __rol _r ON _r.id = _rid.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rid.id_dimension
            WHERE _rid.id_subdimension = ? 
                AND _rid.id_dimension = ? 
                AND _rid.id_rol = ?
                AND _r.id_empresa = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rid.estado = ?
            ORDER BY _rid.id_subdimension desc;";
        $types = 'iiiisss';
        $values = array($data['id_subdimension'],$data['id_dimension'],$data['id_evaluacion'],$this->header['Business-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerIndicadorDesempenoSubdimensionUserRH($data){
        $sql = "SELECT _rid.id AS id_indicador_desempeno
            ,_rid.nombre AS nombre_indicador_desempeno
            ,_rid.id_dimension AS id_dimension
            ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.id_subdimension END AS id_subdimension
	        ,CASE WHEN _rs.estado = 'ELIMINADO' THEN NULL ELSE _rid.nombre END AS nombre_subdimension
            ,_rid.id_rol AS id_evaluacion
            FROM __rol_indicador_desempeno _rid 
            LEFT JOIN __rol_subdimension _rs ON _rs.id = _rid.id_subdimension 
            LEFT JOIN __rol _r ON _r.id = _rid.id_rol
            LEFT JOIN __rol_dimension _rd ON _rd.id = _rid.id_dimension
            WHERE _rid.id_subdimension = ? 
                AND _rid.id_dimension = ? 
                AND _rid.id_rol = ?
                AND _r.id_empresa = ?
                AND _r.id_usuario_asignado = ?
                AND _r.estado = ?
                AND _rd.estado = ?
                AND _rid.estado = ?
            ORDER BY _rid.id_subdimension desc;";
        $types = 'iiiiisss';
        $values = array($data['id_subdimension'],$data['id_dimension'],$data['id_evaluacion'],$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    /* funciones de eliminacion logica de evaluacion de desempeño */
    public function deleteEvaluacionByIdSuperadmin($id){
        $sql = "UPDATE __rol _r 
            SET _r.estado = 'ELIMINADO'
                , _r.fecha_eliminacion = NOW() 
            WHERE _r.id = ?
                AND _r.estado = ?
            ;";
        $types = 'is';
        $values = array($id,"ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteEvaluacionByIdAdmin($id){
        $sql = "UPDATE __rol _r 
            SET _r.estado = 'ELIMINADO'
                , _r.fecha_eliminacion = NOW() 
            WHERE _r.id = ?
                AND _r.id_empresa = ?
                AND _r.estado = ?
            ;";
        $types = 'iis';
        $values = array($id,$this->header['Business-Id'],"ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteEvaluacionByIdUserRH($id){
        $sql = "UPDATE __rol _r 
            SET _r.estado = 'ELIMINADO'
                , _r.fecha_eliminacion = NOW() 
            WHERE _r.id = ?
                AND _r.id_usuario_asignado = ?
                AND _r.id_empresa = ?
                AND _r.estado = ?
            ;";
        $types = 'iiis';
        $values = array($id,$this->header['User-Id'],$this->header['Business-Id'],"ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteIndicadorDesempenoByIdSuperadmin($id){
        $sql = "UPDATE __rol_indicador_desempeno AS _rid
            JOIN __rol_dimension AS _rd ON _rd.id = _rid.id_dimension
            JOIN __rol AS _r ON _r.id = _rid.id_rol
            SET _rid.estado = 'ELIMINADO',
            	_rid.fecha_eliminacion = NOW()
            WHERE _rid.id = ?
            	AND _rid.estado = ? 
            	AND _rd.estado = ?
            	AND _r.estado = ?
            ;";
        $types = 'isss';
        $values = array($id,"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteIndicadorDesempenoByIdAdmin($id){
        $sql = "UPDATE __rol_indicador_desempeno AS _rid
            JOIN __rol_dimension AS _rd ON _rd.id = _rid.id_dimension
            JOIN __rol AS _r ON _r.id = _rid.id_rol
            SET _rid.estado = 'ELIMINADO',
            	_rid.fecha_eliminacion = NOW()
            WHERE _rid.id = ?
            	AND _r.id_empresa = ?
            	AND _rid.estado = ? 
            	AND _rd.estado = ?
            	AND _r.estado = ?
            ;";
        $types = 'iisss';
        $values = array($id,$this->header['Business-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteIndicadorDesenpenoByIdUserRH($id){
        $sql = "UPDATE __rol_indicador_desempeno AS _rid
            JOIN __rol_dimension AS _rd ON _rd.id = _rid.id_dimension
            JOIN __rol AS _r ON _r.id = _rid.id_rol
            SET _rid.estado = 'ELIMINADO',
            	_rid.fecha_eliminacion = NOW()
            WHERE _rid.id = ?
            	AND _r.id_usuario_asignado = ?
            	AND _r.id_empresa = ?
            	AND _rid.estado = ? 
            	AND _rd.estado = ?
            	AND _r.estado = ?
            ;";
        $types = 'iiisss';
        $values = array($id,$this->header['User-Id'],$this->header['Business-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteDimensionByIdSuperadmin($id){
        $sql = "UPDATE __rol_dimension AS _rd
            JOIN __rol AS _r ON _r.id = _rd.id_rol
            SET _rd.estado = 'ELIMINADO',
            	_rd.fecha_eliminacion = NOW()
            WHERE _rd.id = ?
            	AND _r.estado = ?
            	AND _rd.estado = ?
            ;";
        $types = 'iss';
        $values = array($id,"ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteDimensionByIdAdmin($id){
        $sql = "UPDATE __rol_dimension AS _rd
            JOIN __rol AS _r ON _r.id = _rd.id_rol
            SET _rd.estado = 'ELIMINADO',
            	_rd.fecha_eliminacion = NOW()
            WHERE _rd.id = ?
            	AND _r.id_empresa = ?
            	AND _r.estado = ?
            	AND _rd.estado = ?
            ;";
        $types = 'iiss';
        $values = array($id,$this->header['Business-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteDimensionByIdUserRH($id){
        $sql = "UPDATE __rol_dimension AS _rd
            JOIN __rol AS _r ON _r.id = _rd.id_rol
            SET _rd.estado = 'ELIMINADO',
            	_rd.fecha_eliminacion = NOW()
            WHERE _rd.id = ? 
            	AND _r.id_usuario_asignado = ?
            	AND _r.id_empresa = ?
            	AND _r.estado = ?
            	AND _rd.estado = ?
            ;";
        $types = 'iiiss';
        $values = array($id,$this->header['User-Id'],$this->header['Business-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteSubdimensionByIdSuperadmin($id){
        $sql = "UPDATE __rol_subdimension AS _rs
            JOIN __rol_dimension AS _rd ON _rd.id = _rs.id_dimension
            JOIN __rol AS _r ON _r.id = _rs.id_rol
            SET _rs.estado = 'ELIMINADO',
            	_rs.fecha_eliminacion = NOW()
            WHERE _rs.id = ?
               AND _r.estado = ?
               AND _rd.estado = ?
            ;";
        $types = 'iss';
        $values = array($id,"ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteSubdimensionByIdAdmin($id){
        $sql = "UPDATE __rol_subdimension AS _rs
            JOIN __rol_dimension AS _rd ON _rd.id = _rs.id_dimension
            JOIN __rol AS _r ON _r.id = _rs.id_rol
            SET _rs.estado = 'ELIMINADO',
            	_rs.fecha_eliminacion = NOW()
            WHERE _rs.id = ?
               AND _r.id_empresa = ?
               AND _r.estado = ?
               AND _rd.estado = ?
            ;";
        $types = 'iiss';
        $values = array($id,$this->header['Business-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteSubdimensionByIdUserRH($id){
        $sql = "UPDATE __rol_subdimension AS _rs
            JOIN __rol_dimension AS _rd ON _rd.id = _rs.id_dimension
            JOIN __rol AS _r ON _r.id = _rs.id_rol
            SET _rs.estado = 'ELIMINADO',
            	_rs.fecha_eliminacion = NOW()
            WHERE _rs.id = ? 
            	AND _r.id_usuario_asignado = ?
               AND _r.id_empresa = ?
               AND _r.estado = ?
               AND _rd.estado = ?
            ;";
        $types = 'iiiss';
        $values = array($id,$this->header['User-Id'],$this->header['Business-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    /* funciones de actualizacion de evaluacion de desempeño */
    public function updateEvaluacionByIdSuperadmin($id,$data){
        $sql = "UPDATE __rol SET ";
        $params = [];
        $types = "";
        $values = [];
        if (isset($data['nombre']) && $data['nombre'] !== '') {
            $sql .= "nombre = ?, ";
            $types .= "s";
            $values[] = $data['nombre'];
        }
        if (isset($data['descripcion']) && $data['descripcion'] !== '') {
            $sql .= "descripcion = ?, ";
            $types .= "s";
            $values[] = $data['descripcion'];
        }
        if($types == "") throw new Exception("E400");
        $types .= "is";
        $values[] = $id;
        $values[] = 'ACTIVO';
        $sql = rtrim($sql, ", "). " WHERE id = ? AND estado = ?";

        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateEvaluacionByIdAdmin($id,$data){
        $sql = "UPDATE __rol SET ";
        $params = [];
        $types = "";
        $values = [];
        if (isset($data['nombre']) && $data['nombre'] !== '') {
            $sql .= "nombre = ?, ";
            $types .= "s";
            $values[] = $data['nombre'];
        }
        if (isset($data['descripcion']) && $data['descripcion'] !== '') {
            $sql .= "descripcion = ?, ";
            $types .= "s";
            $values[] = $data['descripcion'];
        }
        if($types == "") throw new Exception("E400");
        $types .= "iis";
        $values[] = $id;
        $values[] = $this->header['Business-Id'];
        $values[] = 'ACTIVO';
        $sql = rtrim($sql, ", "). " WHERE id = ? AND id_empresa = ? AND estado = ?";

        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateEvaluacionByIdUserRH($id,$data){
        $sql = "UPDATE __rol SET ";
        $params = [];
        $types = "";
        $values = [];
        if (isset($data['nombre']) && $data['nombre'] !== '') {
            $sql .= "nombre = ?, ";
            $types .= "s";
            $values[] = $data['nombre'];
        }
        if (isset($data['descripcion']) && $data['descripcion'] !== '') {
            $sql .= "descripcion = ?, ";
            $types .= "s";
            $values[] = $data['descripcion'];
        }
        if($types == "") throw new Exception("E400");
        $types .= "iiis";
        $values[] = $id;
        $values[] = $this->header['Business-Id'];
        $values[] = $this->header['User-Id'];
        $values[] = 'ACTIVO';
        $sql = rtrim($sql, ", "). " WHERE id = ? AND id_empresa = ? AND id_usuario_asignado = ? AND estado = ?";

        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateDimensionByIdSuperadmin($id,$data){
        $sql = "UPDATE __rol_dimension AS _rd
            JOIN __rol AS _r ON _r.id = _rd.id_rol
            SET _rd.nombre = ? 
            WHERE _rd.id = ? 
                AND _rd.estado = ? 
                AND _r.estado = ?
            ;";
        $types = "siss";
        $values = array($data["nombre"],$id,"ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateDimensionByIdAdmin($id,$data){
        $sql = "UPDATE __rol_dimension AS _rd
            JOIN __rol AS _r ON _r.id = _rd.id_rol
            SET _rd.nombre = ? 
            WHERE _rd.id = ?
                AND _r.id_empresa = ?
                AND _rd.estado = ? 
                AND _r.estado = ?
            ;";
        $types = "siiss";
        $values = array($data["nombre"],$id,$this->header['Business-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateDimensionByIdUserRH($id,$data){
        $sql = "UPDATE __rol_dimension AS _rd
            JOIN __rol AS _r ON _r.id = _rd.id_rol
            SET _rd.nombre = ? 
            WHERE _rd.id = ? 
                AND _r.id_empresa = ?
                AND _r.id_usuario_asignado = ?
                AND _rd.estado = ? 
                AND _r.estado = ?
            ;";
        $types = "siiiss";
        $values = array($data["nombre"],$id,$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateSubdimensionByIdSuperadmin($id,$data){
        $sql = "UPDATE __rol_subdimension AS _rs
            JOIN __rol_dimension AS _rd ON _rd.id = _rs.id_dimension
            JOIN __rol AS _r ON _r.id = _rs.id_rol
            SET _rs.nombre = ? 
            WHERE _rs.id = ? 
                AND _rs.estado = ?
                AND _rd.estado = ? 
                AND _r.estado = ?
            ;";
        $types = "sisss";
        $values = array($data["nombre"],$id,"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateSubdimensionByIdAdmin($id,$data){
        $sql = "UPDATE __rol_subdimension AS _rs
            JOIN __rol_dimension AS _rd ON _rd.id = _rs.id_dimension
            JOIN __rol AS _r ON _r.id = _rs.id_rol
            SET _rs.nombre = ? 
            WHERE _rs.id = ? 
                AND _r.id_empresa = ?
                AND _rs.estado = ?
                AND _rd.estado = ? 
                AND _r.estado = ?
            ;";
        $types = "siisss";
        $values = array($data["nombre"],$id,$this->header['Business-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateSubdimensionByIdUserRH($id,$data){
        $sql = "UPDATE __rol_subdimension AS _rs
            JOIN __rol_dimension AS _rd ON _rd.id = _rs.id_dimension
            JOIN __rol AS _r ON _r.id = _rs.id_rol
            SET _rs.nombre = ? 
            WHERE _rs.id = ? 
                AND _r.id_empresa = ?
                AND _r.id_usuario_asignado = ?
                AND _rs.estado = ?
                AND _rd.estado = ? 
                AND _r.estado = ?
            ;";
        $types = "siiisss";
        $values = array($data["nombre"],$id,$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateIndicadorDesempenoByIdSuperadmin($id,$data){
        $sql = "UPDATE __rol_indicador_desempeno as _rid
            JOIN __rol_dimension AS _rd ON _rd.id = _rid.id_dimension
            JOIN __rol AS _r ON _r.id = _rid.id_rol
            SET _rid.nombre = ? 
            WHERE _rid.id = ? 
                AND _rd.estado = ? 
                AND _r.estado = ?
                AND _rid.estado = ?
            ;";
        $types = "sisss";
        $values = array($data["nombre"],$id,"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateIndicadorDesempenoByIdAdmin($id,$data){
        $sql = "UPDATE __rol_indicador_desempeno as _rid
            JOIN __rol_dimension AS _rd ON _rd.id = _rid.id_dimension
            JOIN __rol AS _r ON _r.id = _rid.id_rol
            SET _rid.nombre = ?  
            WHERE _rid.id = ?
                AND _r.id_empresa = ?
                AND _rd.estado = ? 
                AND _r.estado = ?
                AND _rid.estado = ?
            ;";
        $types = "siisss";
        $values = array($data["nombre"],$id,$this->header['Business-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateIndicadorDesempenoByIdUserRH($id,$data){
        $sql = "UPDATE __rol_indicador_desempeno as _rid
            JOIN __rol_dimension AS _rd ON _rd.id = _rid.id_dimension
            JOIN __rol AS _r ON _r.id = _rid.id_rol
            SET _rid.nombre = ? 
            WHERE _rid.id = ? 
                AND _r.id_empresa = ?
                AND _r.id_usuario_asignado = ?
                AND _rd.estado = ? 
                AND _r.estado = ? 
                AND _rid.estado = ?
            ;";
        $types = "siiisss";
        $values = array($data["nombre"],$id,$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    /*NIVEL DE LOGRO
    Funciones de creacion */
    public function crearNivelLogroSuperadmin($data){
        $sql = "insert into __nivel_logro(nombre,descripcion,id_rol) values (?,?,?)";
        $types = 'ssi';
        $values = array($data['nombre'],$data['descripcion'],$data['id_evaluacion']);
        $resp = $this->executeInsertQuery($sql,$types,$values);
        return $resp;
    }
    public function crearNivelLogroAdmin($data){
        $sql = "insert into __nivel_logro(nombre,descripcion,id_rol) values (?,?,?)";
        $types = 'ssi';
        $values = array($data['nombre'],$data['descripcion'],$data['id_evaluacion']);
        $resp = $this->executeInsertQuery($sql,$types,$values);
        return $resp;
    }
    public function crearNivelLogroUserRH($data){
        $sql = "insert into __nivel_logro(nombre,descripcion,id_rol) values (?,?,?)";
        $types = 'ssi';
        $values = array($data['nombre'],$data['descripcion'],$data['id_evaluacion']);
        $resp = $this->executeInsertQuery($sql,$types,$values);
        return $resp;
    }
    public function crearDetalleNivelLogro($data){
        $sql = "insert into __nivel_logro_detalle(nombre,valor,id_nivel_logro) values (?,?,?)";
        $types = 'sii';
        $values = array($data['nombre'],$data['valor'],$data['id_nivel_logro']);
        $resp = $this->executeInsertQuery($sql,$types,$values);
        return $resp;
    }
    /*Funciones de obtencion */
    public function obtenerNivelLogro($id){
        $sql = "SELECT _nl.id
            ,_r.id_usuario_asignado
            ,_nl.estado
            ,_r.id_empresa
            FROM __nivel_logro _nl
            LEFT JOIN __rol _r ON _r.id = _nl.id_rol
            WHERE _nl.id = ?
                AND _nl.estado = ?
                AND _r.estado = ?
            ;";
        $types = 'iss';
        $values = array($id,"ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerNivelLogroByDetalleId($id){
        $sql = "SELECT _nl.id
            ,_nl.nombre
            ,_r.id_empresa
            ,_r.id_usuario_asignado 
            FROM __nivel_logro_detalle _nld 
            LEFT JOIN __nivel_logro _nl ON _nl.id = _nld.id_nivel_logro
            LEFT JOIN __rol _r ON _r.id = _nl.id_rol
            WHERE _nld.id = ? 
            	AND _nl.estado = ?
            	AND _r.estado = ?
        ;";
        $types = 'iss';
        $values = array($id,"ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerNivelLogroSuperadmin(){
        $sql = "SELECT _nl.id as id_nivel_logro
            ,_nl.nombre as nombre_nivel
            ,_nl.descripcion as descripcion_nivel
            ,_nl.estado
            ,_nld.id as id_detalle_nivel
            ,_nld.nombre as nombre_detalle_nivel
            ,_nld.valor
        FROM __nivel_logro _nl 
        LEFT JOIN __nivel_logro_detalle _nld ON _nld.id_nivel_logro = _nl.id 
        WHERE AND _nl.estado = ? 
            AND _nld.estado = ?
        ;";
        $types = 'ss';
        $values = array("ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerNivelLogroAdmin(){
        $sql = "SELECT _nl.id as id_nivel_logro
            ,_nl.nombre as nombre_nivel
            ,_nl.descripcion as descripcion_nivel
            ,_nl.estado
            ,_nld.id as id_detalle_nivel
            ,_nld.nombre as nombre_detalle_nivel
            ,_nld.valor
        FROM __nivel_logro _nl 
        LEFT JOIN __nivel_logro_detalle _nld ON _nld.id_nivel_logro = _nl.id 
        LEFT JOIN __rol _r ON _r.id = _nl.id_rol 
        WHERE _r.id_empresa = ?
            AND _nl.estado = ? 
            AND _nld.estado = ?
        ;";
        $types = 'iss';
        $values = array($this->header['Business-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerNivelLogroUserRH(){
        $sql = "SELECT _nl.id as id_nivel_logro
            ,_nl.nombre as nombre_nivel
            ,_nl.descripcion as descripcion_nivel
            ,_nl.estado
            ,_nld.id as id_detalle_nivel
            ,_nld.nombre as nombre_detalle_nivel
            ,_nld.valor
        FROM __nivel_logro _nl 
        LEFT JOIN __nivel_logro_detalle _nld ON _nld.id_nivel_logro = _nl.id
        LEFT JOIN __rol _r ON _r.id = _nl.id_rol
        WHERE _r.id_empresa = ?
            AND _r.id_usuario_asignado = ?
            AND _nl.estado = ? 
            AND _nld.estado = ?
        ;";
        $types = 'iiss';
        $values = array($this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerNivelLogroByIdSuperadmin($id){
        $sql = "SELECT _nl.id as id_nivel_logro
            ,_nl.nombre as nombre_nivel
            ,_nl.descripcion as descripcion_nivel
            ,_nl.estado
            ,_nld.id as id_detalle_nivel
            ,_nld.nombre as nombre_detalle_nivel
            ,_nld.valor
            FROM __nivel_logro _nl 
            LEFT JOIN __nivel_logro_detalle _nld ON _nld.id_nivel_logro = _nl.id 
            WHERE _nl.id = ?
                AND _nl.estado = ? 
                AND _nld.estado = ?
        ;";
        $types = 'iss';
        $values = array($id,"ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerNivelLogroByIdAdmin($id){
        $sql = "SELECT _nl.id as id_nivel_logro
            ,_nl.nombre as nombre_nivel
            ,_nl.descripcion as descripcion_nivel
            ,_nl.estado
            ,_nld.id as id_detalle_nivel
            ,_nld.nombre as nombre_detalle_nivel
            ,_nld.valor
        FROM __nivel_logro _nl 
        LEFT JOIN __nivel_logro_detalle _nld ON _nld.id_nivel_logro = _nl.id 
        LEFT JOIN __rol _r ON _r.id = _nl.id_rol 
        WHERE _nl.id = ?
            AND _nl.id_empresa = ?
            AND _nl.estado = ? 
            AND _nld.estado = ?
        ;";
        $types = 'iiss';
        $values = array($id,$this->header['Business-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerNivelLogroByIdUserRH($id){
        $sql = "SELECT _nl.id as id_nivel_logro
            ,_nl.nombre as nombre_nivel
            ,_nl.descripcion as descripcion_nivel
            ,_nl.estado
            ,_nld.id as id_detalle_nivel
            ,_nld.nombre as nombre_detalle_nivel
            ,_nld.valor
        FROM __nivel_logro _nl 
        LEFT JOIN __nivel_logro_detalle _nld ON _nld.id_nivel_logro = _nl.id 
        LEFT JOIN __rol _r ON _r.id = _nl.id_rol
        WHERE _nl.id = ?
            AND _r.id_empresa = ?
            AND _r.id_usuario_asignado = ?
            AND _nl.estado = ? 
            AND _nld.estado = ?
        ;";
        $types = 'iiiss';
        $values = array($id,$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    /*Funciones de eliminacion */
    public function eliminarNivelLogroSuperadmin($id){
        $sql = "UPDATE __nivel_logro AS _nl
            JOIN __rol AS _r ON _r.id = _nl.id_rol
            SET _nl.estado = 'ELIMINADO',
            	_nl.fecha_eliminacion = NOW()
            WHERE _nl.id = ? 
                AND _nl.estado = ?
                AND _r.estado = ?
            ;";
        $types = 'iss';
        $values = array($id,"ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function eliminarNivelLogroAdmin($id){
        $sql = "UPDATE __nivel_logro AS _nl
            JOIN __rol AS _r ON _r.id = _nl.id_rol
            SET _nl.estado = 'ELIMINADO',
            	_nl.fecha_eliminacion = NOW()
            WHERE _nl.id = ?
                AND _r.id_empresa = ?
                AND _nl.estado = ?
                AND _r.estado = ?
            ;";
        $types = 'iiss';
        $values = array($id,$this->header['Business-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function eliminarNivelLogroUserRH($id){
        $sql = "UPDATE __nivel_logro AS _nl
            JOIN __rol AS _r ON _r.id = _nl.id_rol
            SET _nl.estado = 'ELIMINADO',
            	_nl.fecha_eliminacion = NOW()
            WHERE _nl.id = ?
                AND _r.id_empresa = ?
                AND _r.id_usuario_asignado = ?
                AND _nl.estado = ?
                AND _r.estado = ?
            ;";
        $types = 'iiiss';
        $values = array($id,$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function eliminarNivelLogroDetalleSuperadmin($id){
        $sql = "UPDATE __nivel_logro_detalle AS _nld
            JOIN __nivel_logro AS _nl ON _nl.id = _nld.id_nivel_logro
            JOIN __rol AS _r ON _r.id = _nl.id_rol
            SET _nld.estado = 'ELIMINADO',
            	_nld.fecha_eliminacion = NOW()
            WHERE _nld.id = ? 
                AND _nld.estado = ?
                AND _nl.estado = ?
                AND _r.estado = ? 
            ;";
        $types = 'isss';
        $values = array($id,"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function eliminarNivelLogroDetalleAdmin($id){
        $sql = "UPDATE __nivel_logro_detalle AS _nld
            JOIN __nivel_logro AS _nl ON _nl.id = _nld.id_nivel_logro
            JOIN __rol AS _r ON _r.id = _nl.id_rol
            SET _nld.estado = 'ELIMINADO',
            	_nld.fecha_eliminacion = NOW()
            WHERE _nld.id = ?
                AND _r.id_empresa = ?
                AND _nld.estado = ?
                AND _nl.estado = ?
                AND _r.estado = ?
            ;";
        $types = 'iisss';
        $values = array($id,$this->header['Business-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function eliminarNivelLogroDetalleUserRH($id){
        $sql = "UPDATE __nivel_logro_detalle AS _nld
            JOIN __nivel_logro AS _nl ON _nl.id = _nld.id_nivel_logro
            JOIN __rol AS _r ON _r.id = _nl.id_rol
            SET _nld.estado = 'ELIMINADO',
            	_nld.fecha_eliminacion = NOW()
            WHERE _nld.id = ?
                AND _r.id_empresa = ?
                AND _r.id_usuario_asignado = ?
                AND _nld.estado = ?
                AND _nl.estado = ?
                AND _r.estado = ?
            ;";
        $types = 'iiisss';
        $values = array($id,$this->header['Business-Id'],$this->header['User-Id'],"ACTIVO","ACTIVO","ACTIVO");
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    /* Funciones de actualizacion */
    public function updateNivelLogroByIdSuperadmin($id,$data){
        $sql = "UPDATE __nivel_logro AS _nl
            JOIN __rol AS _r on _r.id = _nl.id_rol
            SET ";
        $params = [];
        $types = "";
        $values = [];
        if (isset($data['nombre'])) {
            $sql .= "_nl.nombre = ?, ";
            $types .= "s";
            $values[] = $data['nombre'];
        }
        if (isset($data['descripcion'])) {
            $sql .= "_nl.descripcion = ?, ";
            $types .= "s";
            $values[] = $data['descripcion'];
        }
        if($types == "") throw new Exception("E400");
        $types .= "iiss";
        $values[] = $id;
        $values[] = $data['id_evaluacion'];
        $values[] = "ACTIVO";
        $values[] = "ACTIVO";
        $sql = rtrim($sql, ", "). " WHERE _nl.id = ? 
            AND _r.id = ? 
            AND _nl.estado = ? 
            AND _r.estado = ?
        ;";
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;    
    }
    public function updateNivelLogroByIdAdmin($id,$data){
        $sql = "UPDATE __nivel_logro AS _nl
            JOIN __rol AS _r on _r.id = _nl.id_rol
            SET ";
        $params = [];
        $types = "";
        $values = [];
        if (isset($data['nombre'])) {
            $sql .= "_nl.nombre = ?, ";
            $types .= "s";
            $values[] = $data['nombre'];
        }
        if (isset($data['descripcion'])) {
            $sql .= "_nl.descripcion = ?, ";
            $types .= "s";
            $values[] = $data['descripcion'];
        }
        if($types == "") throw new Exception("E400");
        $types .= "iiiss";
        $values[] = $id;
        $values[] = $data['id_evaluacion'];
        $values[] = $this->header['Business-Id'];
        $values[] = "ACTIVO";
        $values[] = "ACTIVO";
        $sql = rtrim($sql, ", "). " WHERE _nl.id = ? 
            AND _r.id = ? 
            AND _r.id_empresa = ?
            AND _nl.estado = ? 
            AND _r.estado = ?
        ;";
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;    
    }
    public function updateNivelLogroByIdUserRH($id,$data){
        $sql = "UPDATE __nivel_logro AS _nl
            JOIN __rol AS _r on _r.id = _nl.id_rol
            SET ";
        $params = [];
        $types = "";
        $values = [];
        if (isset($data['nombre'])) {
            $sql .= "_nl.nombre = ?, ";
            $types .= "s";
            $values[] = $data['nombre'];
        }
        if (isset($data['descripcion'])) {
            $sql .= "_nl.descripcion = ?, ";
            $types .= "s";
            $values[] = $data['descripcion'];
        }
        if($types == "") throw new Exception("E400");
        $types .= "iiiiss";
        $values[] = $id;
        $values[] = $data['id_evaluacion'];
        $values[] = $this->header['Business-Id'];
        $values[] = $this->header['User-Id'];
        $values[] = "ACTIVO";
        $values[] = "ACTIVO";
        $sql = rtrim($sql, ", "). " WHERE _nl.id = ? 
            AND _r.id = ? 
            AND _r.id_empresa = ?
            AND _r.id_usuario_asignado = ?
            AND _nl.estado = ? 
            AND _r.estado = ?
        ;";
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;    
    }
    public function updateDetalleNivelLogroByIdSuperadmin($id,$data){
        $sql = "UPDATE __nivel_logro_detalle as _nld
            JOIN __nivel_logro AS _nl ON _nl.id = _nld.id
            JOIN __rol AS _r on _r.id = _nl.id_rol
            SET ";
        $params = [];
        $types = "";
        $values = [];
        if (isset($data['nombre'])) {
            $sql .= "_nld.nombre = ?, ";
            $types .= "s";
            $values[] = $data['nombre'];
        }
        if (isset($data['valor'])) {
            $sql .= "_nld.valor = ?, ";
            $types .= "s";
            $values[] = $data['valor'];
        }
        if($types == "") throw new Exception("E400");
        $types .= "iisss";
        $values[] = $id;
        $values[] = $data['id_nivel_logro'];
        $values[] = "ACTIVO";
        $values[] = "ACTIVO";
        $values[] = "ACTIVO";
        $sql = rtrim($sql, ", "). " WHERE _nld.id = ? AND _nl.id = ? AND _nl.estado = ? AND _r.estado = ? AND _nld.estado = ?";
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateDetalleNivelLogroByIdAdmin($id,$data){
        $sql = "UPDATE __nivel_logro_detalle as _nld
            JOIN __nivel_logro AS _nl ON _nl.id = _nld.id
            JOIN __rol AS _r on _r.id = _nl.id_rol
            SET ";
        $params = [];
        $types = "";
        $values = [];
        if (isset($data['nombre'])) {
            $sql .= "_nld.nombre = ?, ";
            $types .= "s";
            $values[] = $data['nombre'];
        }
        if (isset($data['valor'])) {
            $sql .= "_nld.valor = ?, ";
            $types .= "s";
            $values[] = $data['valor'];
        }
        if($types == "") throw new Exception("E400");
        $types .= "iiisss";
        $values[] = $id;
        $values[] = $data['id_nivel_logro'];
        $values[] = $this->header['Business-Id'];
        $values[] = "ACTIVO";
        $values[] = "ACTIVO";
        $values[] = "ACTIVO";
        $sql = rtrim($sql, ", "). " WHERE _nld.id = ? AND _nl.id = ? AND _r.id_empresa = ? AND _nl.estado = ? AND _r.estado = ? AND _nld.estado = ?";
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateDetalleNivelLogroByIdUserRH($id,$data){
        $sql = "UPDATE __nivel_logro_detalle as _nld
            JOIN __nivel_logro AS _nl ON _nl.id = _nld.id
            JOIN __rol AS _r on _r.id = _nl.id_rol
            SET ";
        $params = [];
        $types = "";
        $values = [];
        if (isset($data['nombre'])) {
            $sql .= "_nld.nombre = ?, ";
            $types .= "s";
            $values[] = $data['nombre'];
        }
        if (isset($data['valor'])) {
            $sql .= "_nld.valor = ?, ";
            $types .= "s";
            $values[] = $data['valor'];
        }
        if($types == "") throw new Exception("E400");
        $types .= "iiiisss";
        $values[] = $id;
        $values[] = $data['id_nivel_logro'];
        $values[] = $this->header['Business-Id'];
        $values[] = $this->header['User-Id'];
        $values[] = "ACTIVO";
        $values[] = "ACTIVO";
        $values[] = "ACTIVO";
        $sql = rtrim($sql, ", "). " WHERE _nld.id = ? 
            AND _nl.id = ? 
            AND _r.id_empresa = ? 
            AND _r.id_usuario_asignado = ?
            AND _nl.estado = ? 
            AND _r.estado = ? 
            AND _nld.estado = ?
        ;";
        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    /* funcion de agregado a la papelera de reciclaje */
    public function agregarPapeleraReciclaje($data){
        $sql = "INSERT INTO __papelera_reciclaje (id_elemento,tipo_elemento,id_usuario,id_empresa,uuid_eliminacion,id_usuario_eliminador) VALUES(?,?,?,?,?,?);";
        $types = 'isiisi';
        $values = array($data['idElemento'],$data['tipo_elemento'],$data['id_usuario'],$data['id_empresa'],$data['uuid_eliminacion'],$data['id_usuario_eliminador']);
        $resp = $this->executeInsertQuery($sql,$types,$values);
        return $resp;
    }
    
    
    /*funciones de ejecucion de SQL*/
    private function executeSelectQuery($sql,$type = '',$values = []){
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("E501", $this->mysqli->error);
        }
        if($type != '') $stmt->bind_param($type, ...$values);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $resp[] = $row;
        }
        $stmt->close();
        return $resp ?? false;
    }
    private function executeInsertQuery($sql,$type = '',$values = []){
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("E501", $this->mysqli->error);
        }
        if($type != '') $stmt->bind_param($type, ...$values);
        if(!$stmt->execute()) throw new Exception("Error al crear: " . $stmt->error);
        $id = $this->mysqli->insert_id;
        $stmt->close();
        return $id;
    }
    private function executeUpdateQuery($sql,$types = '',$values = []){
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("E501", $this->mysqli->error);
        }
        if($types != '') $stmt->bind_param($types, ...$values);
        if (!$stmt->execute()) {
            throw new Exception('E502');
        }
        $affected_rows = $stmt->affected_rows;
        $info = $this->mysqli->info;
        $matched = null;
        if (preg_match('/Rows matched:\s*(\d+)/', $info, $m)) {
          $matched = (int)$m[1];
        }
        $stmt->close();
        $outp = array("m" => $affected_rows , "c"=> $matched);

        return $outp;
    }

}
?>