<?php
class ErrorDictionary {
    public static function getErrorStructure($errorCode,$errorMessage = NULL,$data = NULL){
        $errors = [
            'E001' => [
                "statusCode" => 405,
                "code" => 'E001',
                "message" => 'Método no permitido',
                "type" => 'error',
                "errors" => 'Método no permitido',
                "data" => $data
            ],
            'E002' => [
                "statusCode" => 404,
                "code" => 'E002',
                "message" => 'Recurso No encontrado',
                "type" => 'error',
                "errors" => $errorMessage,
                "data" => $data
            ],
            'E003' => [
                "statusCode" => 400,
                "code" => 'E003',
                "message" => 'Parametros invalidos',
                "type" => 'error',
                "errors" => $errorMessage,
                "data" => $data
            ],
            'E004' => [
                "statusCode" => 500,
                "code" => 'E004',
                "message" => 'Usuario no autorizado para consultar este recurso',
                "type" => 'error',
                "errors" => 'Usuario no autorizado',
                "data" => $data
            ],
            'E005' => [
                "statusCode" => 404,
                "code" => 'E005',
                "message" => 'Usuario a actualizar no encontrado',
                "type" => 'error',
                "errors" => 'Usuario a actualizar no encontrado o invalido',
                "data" => $data
            ],
            'E006' => [
                "statusCode" => 404,
                "code" => 'E006',
                "message" => 'usuario a eliminar no encontrado',
                "type" => 'error',
                "errors" => 'Usuario a eliminar no encontrado o invalido',
                "data" => $data
            ],
            'E007' => [
                "statusCode" => 404,
                "code" => 'E007',
                "message" => 'No se realizaron modificaciones al registro',
                "type" => 'error',
                "errors" => 'Registro sin cambio o no encontrado',
                "data" => $data
            ],
            'E008' => [
                "statusCode" => 500,
                "code" => 'E008',
                "message" => 'Usuario no autorizado para eliminar este registro',
                "type" => 'error',
                "errors" => 'Usuario no autorizado',
                "data" => $data
            ],
            'E009' => [
                "statusCode" => 500,
                "code" => 'E009',
                "message" => 'No puedes eliminar tu propia cuenta',
                "type" => 'error',
                "errors" => 'El usuario no tiene permitido eliminar su propia cuenta',
                "data" => $data
            ],
            'E010' => [
                "statusCode" => 401,
                "code" => 'E010',
                "message" => 'Token invalido',
                "type" => 'error',
                "errors" => 'Authorization no ha sido provisto o es invalido',
                "data" => $data
            ],
            'E011' => [
                "statusCode" => 400,
                "code" => 'E011',
                "message" => 'Error en los parametros de la llamada',
                "type" => 'error',
                "errors" => $errorMessage,
                "data" => $data
            ],
            'E012' => [
                "statusCode" => 404,
                "code" => 'E012',
                "message" => 'Error al procesar la solicitud',
                "type" => 'error',
                "errors" => 'datos solicitados no encontrados',
                "data" => $data
            ],
            'E400' => [
                "statusCode" => 400,
                "code" => 'E400',
                "message" => 'Error en los parametros de la llamada',
                "type" => 'error',
                "errors" => $errorMessage,
                "data" => $data
            ],
            'E401' => [
                "statusCode" => 401,
                "code" => 'E401',
                "message" => 'Usuario no autorizado',
                "type" => 'error',
                "errors" => 'Usuario no tiene permitido acceder a este servicio',
                "data" => $data
            ],
            'E404' => [
                "statusCode" => 404,
                "code" => 'E404',
                "message" => 'Error al procesar la solicitud',
                "type" => 'error',
                "errors" => 'datos solicitados no encontrados',
                "data" => $data
            ],
            'E500' => [
                "statusCode" => 500,
                "code" => 'E012',
                "message" => 'Error al procesar la solicitud',
                "type" => 'error',
                "errors" => 'Internal server error',
                "data" => $data
            ],
            'E501' => [
                "statusCode" => 500,
                "code" => 'E501',
                "message" => 'Error al procesar la solicitud',
                "type" => 'error',
                "errors" => 'Internal server error in prepare consulting stage',
                "data" => $data
            ],
        ];
        return $errors[$errorCode] ?? [
            "statusCode" => 500,
            "code" => 'E-999',
            "message" => 'Error desconocido en el sistema, por favor intente mas tarde',
            "type" => 'error',
            "errors" => 'Internal server error: '.$errorCode,
            "data" => $data
        ];
    }
    public static function getSuccessStructure($code,$data = NULL,$error = NULL){
        $success = [
            'S001' => [
                "statusCode" => 200,
                "code" => 'S001',
                "message" => 'solicitud procesada con exito',
                "type" => 'success',
                "errors" => $error,
                "data" => $data
            ],
            'S002' => [
                "statusCode" => 201,
                "code" => 'S002',
                "message" => 'Usuario creado con exito',
                "type" => 'success',
                "errors" => $error,
                "data" => $data
            ],
            'S003' => [
                "statusCode" => 200,
                "code" => 'S003',
                "message" => 'Usuario actualizado con exito',
                "type" => 'success',
                "errors" => $error,
                "data" => $data
            ],
            'S004' => [
                "statusCode" => 200,
                "code" => 'S004',
                "message" => 'Usuario eliminado con exito',
                "type" => 'success',
                "errors" => $error,
                "data" => $data
            ],
        ];
        return $success[$code] ?? [
            "statusCode" => 200,
            "code" => 'S000',
            "message" => 'Solicitud procesada exitosamente',
            "type" => 'success',
            "errors" => $error,
            "data" => $data
        ];
    }
}

?>