<?php
class Evaluacion {
    private $mysqli;
    private $header;

    public function __construct($mysqli,$header) {
        $this->mysqli = $mysqli;
        $this->mysqli->set_charset("utf8mb4");
        $this->header = $header;
    }
    public function obtenerEvaluacionDetalle($id){
        $sql = "CALL sp_obtener_evaluaciones_detalle_aplicacion(?);";
        $types = 'i';
        $values[] = $id; 
        $resp = $this->executeSelectQuery($sql,$types,$values);
        return $resp;
    }
    public function obtenerEvaluaciones(){
        $sql = "CALL sp_obtener_evaluaciones_aplicacion();";
        $resp = $this->executeSelectQuery($sql);
        return $resp;
    }
    
    
    /*funciones de ejecucion de SQL*/
    private function executeSelectQuery($sql,$type = '',$values = []){
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("E501", $this->mysqli->error);
        }
        if($type != '') $stmt->bind_param($type, ...$values);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $resp[] = $row;
        }
        $stmt->close();
        return $resp ?? false;
    }
    private function executeInsertQuery($sql,$type = '',$values = []){
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("E501", $this->mysqli->error);
        }
        if($type != '') $stmt->bind_param($type, ...$values);
        if(!$stmt->execute()) throw new Exception("Error al crear: " . $stmt->error);
        $id = $this->mysqli->insert_id;
        $stmt->close();
        return $id;
    }
    private function executeUpdateQuery($sql,$types = '',$values = []){
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("E501", $this->mysqli->error);
        }
        if($types != '') $stmt->bind_param($types, ...$values);
        if (!$stmt->execute()) {
            throw new Exception('E502');
        }
        $affected_rows = $stmt->affected_rows;
        $info = $this->mysqli->info;
        $matched = null;
        if (preg_match('/Rows matched:\s*(\d+)/', $info, $m)) {
          $matched = (int)$m[1];
        }
        $stmt->close();
        $outp = array("m" => $affected_rows , "c"=> $matched);

        return $outp;
    }
    private function executeProcedureCreate($sql,$types,$values){
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("E501", $this->mysqli->error);
        }
        $stmt->bind_param($types, ...$values);
        $stmt->execute();
        $stmt->close();
        while ($this->mysqli->more_results() && $this->mysqli->next_result()) {
            if ($res = $this->mysqli->use_result()) { $res->free(); }
        }
        $res = $this->mysqli->query("SELECT @p_new_id AS id");
        $nuevoId = $res->fetch_assoc()['id'] ?? null;
        $res->free();
        return $nuevoId;
    }
}
?>