<?php

header('Content-Type: application/json');
require 'vendor/autoload.php';
require_once 'utils/ApiResponse.php';
require_once 'utils/ValidateHeaderRule.php';
require_once 'routes/api.php';
require_once 'controllers/ValidateUserController.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

// Configurar zona horaria
date_default_timezone_set('America/Caracas');
// Conexión a la base de datos
$config = require 'config/database.php';
$headers = getallheaders();
$headerError = null;
if($headerError = ValidateHeader::validate($headers)) ApiResponse::error('E003',$headerError);
$token = str_replace('Bearer ', '', $headers['Authorization']);

try{
    $mysqli = new mysqli($config['host'], $config['usuario'], $config['contrasena'], $config['base_datos']);
    if ($mysqli->connect_error) {
        throw new Exception('E500');
    }
}catch (Exception $e){
    ApiResponse::error($e->getMessage());
}
// try {
//     $decoded = JWT::decode($token, new Key($config['jwt_secret'], 'HS256'));
//     if (!isset($decoded->iss) || !isset($decoded->sub) || !isset($decoded->exp) || !isset($decoded->iat) || !isset($decoded->role) || !isset($decoded->sessionCode)) {
//         throw new Exception('E010');
//     }else{
//         $validaUsuario = new ValidateUserController($mysqli);
//         if(!$validaUsuario->validateUser($decoded)) throw new Exception('E010');
//         $headers['profile'] = $decoded->role;
//     }
// } catch (Exception $e) {
//     ApiResponse::error('E010');
// }
$router = new Router($mysqli,$headers);
$router->route($headers);
$mysqli->close();
?>