<?php
require_once __DIR__ . '/../models/Evaluacion.php';
class EvaluacionController {
    private $evaluacionModel;
    private $dataErrors = [];
    private $header = [];
    public function __construct($mysqli,$header) {
        $this->evaluacionModel = new Evaluacion($mysqli,$header);
        $this->header = $header;
    }

    /* EVALUACION DE DESEMPEÑO
     funciones de creacion */
       
    /* funciones de obtencion */
    public function obtenerEvaluacionDetalle($id){
        try {
            $outp = $this->evaluacionModel->obtenerEvaluacionDetalle($id);
            if(!$outp) ApiResponse::success('S001',[]);
            $resp = $this->formateaEvaluacionDetalle($outp);
            if($resp) ApiResponse::success('S001',$resp); throw new Exception("E404");
            // if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function obtenerEvaluaciones(){
        try {
            $outp = $this->evaluacionModel->obtenerEvaluaciones();
            if(!$outp) ApiResponse::success('S001',[]);
            $resp = $this->formateaListadoEvaluaciones($outp);
            if($resp) ApiResponse::success('S001',$resp); throw new Exception("E404");
            // if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    /* funciones privadas de la clase*/
    /* formatear el resultado de la consulta de indicador de desempeño*/
    private function formateaEvaluacionDetalle($input){
        function escala_1_5(): array {
            return [
                [ 'valor' => 1, 'etiqueta' => 'Deficiente' ],
                [ 'valor' => 2, 'etiqueta' => 'Regular' ],
                [ 'valor' => 3, 'etiqueta' => 'Bueno' ],
                [ 'valor' => 4, 'etiqueta' => 'Muy bueno' ],
                [ 'valor' => 5, 'etiqueta' => 'Excelente' ],
            ];
        }

        $evaluacionId   = $input[0]['id_evaluacion']     ?? 1;
        $evaluacionName = $input[0]['nombre_evaluacion'] ?? 'Evaluación de Desempeño';
        $evaluacionDesc = $input[0]['descripcion_evaluacion'] ?? '';
        $fechaLimite = $input[0]['fecha_limite'] ?? '';
        $contadorPregunta = 1;

        $dimMap = []; // id_dimension => {id, nombre, preguntas[], subdimensiones[id_sub]}

        foreach ($input as $row) {
            $idDim  = $row['id_dimension'];
            $nomDim = $row['nombre_dimension'];
        
            if (!isset($dimMap[$idDim])) {
                $dimMap[$idDim] = [
                    'id'             => 'dim-' . $idDim,
                    'nombre'         => $nomDim,
                    'descripcion'    => 'Auto-generada desde indicadores de desempeño.',
                    'preguntas'      => [],   // aquí van SOLO las que NO tienen subdimensión
                    'subdimensiones' => []    // mapa id_subdimension => {id_subdimension, nombre_subdimension, preguntas[]}
                ];
            }
        
            // Construir la pregunta desde el indicador
            $pregunta = [
                'id'       => $row['id_indicador_desempeno'],
                'texto'    => $row['nombre_indicador_desempeno'] ?? ('Indicador ' . ($row['id_indicador_desempeno'] ?? '')),
                'tipo'     => 'escala',
                'opciones' => escala_1_5()
            ];
        
            // Regla corregida: por cada pregunta, decidir destino
            if ($row['id_subdimension'] !== null) {
                $idSub  = $row['id_subdimension'];
                $nomSub = $row['nombre_subdimension'] ?? 'Subdimensión';
            
                if (!isset($dimMap[$idDim]['subdimensiones'][$idSub])) {
                    $dimMap[$idDim]['subdimensiones'][$idSub] = [
                        'id_subdimension'     => $idSub,
                        'nombre_subdimension' => $nomSub,
                        'preguntas'           => []
                    ];
                }
                $dimMap[$idDim]['subdimensiones'][$idSub]['preguntas'][] = $pregunta;
            } else {
                // Sin subdimensión: se queda en preguntas de la dimensión
                $dimMap[$idDim]['preguntas'][] = $pregunta;
            }
        }

        // (Opcional) agregar “Comentarios adicionales” en cada dimensión
        /*
        foreach ($dimMap as &$dim) {
            $dim['preguntas'][] = [
                'id'        => 'q' . $contadorPregunta++,
                'texto'     => 'Comentarios adicionales',
                'tipo'      => 'texto',
                'requerido' => false
            ];
            // Pasar subdimensiones a array indexado
            $dim['subdimensiones'] = array_values($dim['subdimensiones']);
        }*/
        unset($dim);

        // Construir el objeto final de evaluación
        $result = [[
            'id'          => $evaluacionId,
            'titulo'      => $evaluacionName,
            'descripcion' => $evaluacionDesc,
            'fechaLimite' => $fechaLimite,
            'dimensiones' => array_values($dimMap)
        ]];
        
        // (Opcional) ordenar dimensiones por id numérico
        // usort($result[0]['dimensiones'], function($a, $b) {
        //     $aid = (int)filter_var($a['id'], FILTER_SANITIZE_NUMBER_INT);
        //     $bid = (int)filter_var($b['id'], FILTER_SANITIZE_NUMBER_INT);
        //     return $aid <=> $bid;
        // });
        return $result;

    }
    private function formateaListadoEvaluaciones($input){
        /**
         * Mapea (heurística simple) icono y tipo a partir del nombre.
         * Ajusta a tu conveniencia.
         */
        function mapIconAndType(string $nombre): array {
            $lower = mb_strtolower($nombre, 'UTF-8');
            if (str_contains($lower, 'clima'))       return ['fa-chart-pie', 'encuesta'];
            if (str_contains($lower, 'técnic') || str_contains($lower, 'tecnic')) 
                                                    return ['fa-laptop-code', 'técnica'];
            if (str_contains($lower, 'desempeño') || str_contains($lower, 'desempeno')) 
                                                    return ['fa-clipboard-check', 'desempeño'];
            return ['fa-file-alt', 'desempeño'];
        }

        $pendientes = [];
        $completadas = [];
        $vencidas = [];

        foreach ($input as $row) {
            $id    = (int)$row['id_evaluacion'];
            $titulo = $row['nombre_evaluacion'] ?? '';
            $desc   = $row['descripcion_evaluacion'] ?? '';
            $estado = strtoupper(trim($row['estado_evaluacion'] ?? ''));
        
            [$icono, $tipo] = mapIconAndType($titulo);
        
            if ($estado === 'PENDIENTE') {
                // Estructura para PENDIENTE
                $pendientes[] = [
                    'id'               => $id,
                    'titulo'           => $titulo,
                    'descripcion'      => $desc ?: 'Evaluación pendiente.',
                    'fechaVencimiento' => $row['fecha_aplicacion'],   // <-- coloca tu fecha si la tienes
                    'progreso'         => 0,
                    'icono'            => $icono,
                    'tipo'             => $tipo
                ];
            } elseif ($estado === 'COMPLETADA' || $estado === 'COMPLETADO') {
                // Estructura para COMPLETADA/COMPLETADO
                $completadas[] = [
                    'id'               => $id,
                    'titulo'           => $titulo,
                    'descripcion'      => $desc ?: 'Evaluación completada.',
                    'fechaCompletada'  => $row['fecha_aplicacion'],   // <-- coloca tu fecha si la tienes
                    'calificacion'     => 8.6,   // <-- coloca tu score si lo tienes
                    'icono'            => $icono,
                    'tipo'             => $tipo
                ];
            } elseif ($estado === 'VENCIDA') {
                // Estructura para VENCIDA (similar a completadas; si prefieres "fechaVencimiento", cámbialo)
                $vencidas[] = [
                    'id'               => $id,
                    'titulo'           => $titulo,
                    'descripcion'      => $desc ?: 'Evaluación vencida.',
                    'fechaCompletada'  => $row['fecha_aplicacion'],   // o usa 'fechaVencimiento' si corresponde a tu modelo
                    'calificacion'     => "-",
                    'icono'            => $icono,
                    'tipo'             => $tipo
                ];
            }
        }

        // Resultado final separado por estado
        $resultado = [
            'PENDIENTE'   => $pendientes,
            'COMPLETADA'  => $completadas,
            'VENCIDA'     => $vencidas,
        ];
        return $resultado;
    }
    private function formateaClasificacion($data){
        $grouped = [];

        foreach ($data as $row) {
            // clave de agrupación estable
            $key = implode('|', [
                (string)($row['id_clasificacion'] ?? ''),
                (string)($row['nombre_clasificacion'] ?? ''),
                (string)($row['id_evaluacion'] ?? '')
            ]);

            if (!isset($grouped[$key])) {
                $grouped[$key] = [
                    'id_evaluacion'    => $row['id_evaluacion'] ?? null,
                    'id_clasificacion'       => $row['id_clasificacion'] ?? null,
                    'nombre_clasificacion'=> $row['nombre_clasificacion'] ?? null,
                    'detalle_clasificacion'=> [] // <— con ñ, preservado en UTF-8
                ];
            }
            // arma cada indicador con los campos que quieres mostrar
            $indicator = [];
            if (array_key_exists('id_detalle_clasificacion', $row) && $row['id_detalle_clasificacion'] != null) $indicator['id_detalle_clasificacion'] = $row['id_detalle_clasificacion'];
            if (array_key_exists('nombre_detalle_clasificacion', $row) && $row['nombre_detalle_clasificacion'] != null) $indicator['nombre_detalle_clasificacion'] = $row['nombre_detalle_clasificacion'];
            if (array_key_exists('porcentaje_cumplimiento', $row) && $row['porcentaje_cumplimiento'] != null) $indicator['porcentaje_cumplimiento'] = $row['porcentaje_cumplimiento'];
            if (array_key_exists('operador_logico', $row) && $row['operador_logico'] != null ) $indicator['operador_logico'] = $row['operador_logico'];
            if ($indicator != []) $grouped[$key]['detalle_clasificacion'][] = $indicator;
        }

        $output = array_values($grouped);
        return $output;
    }
    /* funcion de generacion de UUID v4 */
    private function generateUuidV4(): string {
        $data = random_bytes(16);
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40); // Establecer versión 4
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80); // Establecer variante
        return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
    }
}
?>