<?php
function validateProcess($validationRules,$data){
        $errors = [];
    
    foreach ($validationRules as $field => $rule) {
        // Verificar si el campo es obligatorio
        if ($rule['required'] && !isset($data[$field])) {
            $errors[] = "Field '$field' is required";
            continue;
        }
        // Si el campo no está presente y no es obligatorio, continuar
        if (!isset($data[$field]) && !$rule['required']) {
            continue;
        }
        // Verificar si el campo puede estar vacio
        if ($rule['notEmpty'] && $data[$field]==""){
            $errors[] = "Field '$field' must not be empty";
            continue;
        }
        if(isset($rule['isStatus']) && $rule['isStatus'] == true && !($data[$field] === "ACTIVO" || $data[$field] === "INACTIVO" || $data[$field] === "BLOQUEADO")){
            $errors[] = "Field '$field' accepts only ACTIVO, INACTIVO OR BLOQUEADO values";
            continue;
        }
        
        
        $value = $data[$field];
        
        // Validar tipo de dato
        switch ($rule['type']) {
            case 'string':
                if (!is_string($value)) $errors[] = "Field '$field' must be a string";
                if (isset($rule['max_length']) && strlen($value) > $rule['max_length']) $errors[] = "Field '$field' exceeds maximum length of {$rule['max_length']}";
                break;
            case 'integer':
                if (!is_numeric($value) || floor($value) != $value) $errors[] = "Field '$field' must be an integer";
                if (isset($rule['min']) && $value < $rule['min']) $errors[] = "Field '$field' must be at least {$rule['min']}";
                if (isset($rule['max']) && $value > $rule['max']) $errors[] = "Field '$field' must not exceed {$rule['max']}";
                break;
            case 'email':
                if (!filter_var($value, FILTER_VALIDATE_EMAIL)) $errors[] = "Field '$field' must be a valid email address";
                break;
            case 'boolean':
                if (!is_bool($value) && $value !== 0 && $value !== 1) $errors[] = "Field '$field' must be a boolean";
                break;
            case 'datetime':
                $format = 'Y-m-d H:i:s';
                $dateTime = DateTime::createFromFormat($format, $value);
                if (!$dateTime || $dateTime->format($format) !== $value) $errors[] = "Field '$field' must be a valid datetime (YYYY-MM-DD HH:MM:SS)";
                break;
            case 'date':
                $format = 'Y-m-d';
                $dateTime = DateTime::createFromFormat($format, $value);
                if (!$dateTime || $dateTime->format($format) !== $value) $errors[] = "Field '$field' must be a valid datetime (YYYY-MM-DD)";
                break;
        }
    
    }
    return $errors;
}
class ValidateData{
    public static function validateCreationBusiness($data){
        $validationRules = [
            'rut' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
                'min' => 100000,
                'max' => 99999999
            ],
            'dv' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
                'max_length' => 1
            ],
            'nombre' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
                'max_length' => 250
            ],
            'direccion' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
                'max_length' => 500
            ],
            'id_comuna' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
                'min' => 0,
                'max' => 99999999999
            ],
            'rut_representante' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
                'min' => 100000,
                'max' => 99999999
            ],
            'dv_representante' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
                'max_length' => 1
            ],
            'representante_legal' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
                'max_length' => 250
            ],
            'email_representante_legal' => [
                'type' => 'email',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
                'max_length' => 254
            ],
            'telefono_representante_legal' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
                'max_length' => 11,
                'min_length' => 11
            ],
            'fecha_inicio_operacion' => [
                'type' => 'date',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
            ],
            'fecha_termino_operacion' => [
                'type' => 'date',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
            ],
            'id_tipo_organizacion' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => true,
                'isStatus' => false,
                'min' => 1,
                'max' => 99999999999
            ]            
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
    public static function validateUpdateBusiness($data){
        $validationRules = [
            'nombre' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false,
                'max_length' => 250
            ],
            'direccion' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false,
                'max_length' => 500
            ],
            'id_comuna' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false,
                'min' => 0,
                'max' => 99999999999
            ],
            'rut_representante' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false,
                'min' => 100000,
                'max' => 99999999
            ],
            'dv_representante' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false,
                'max_length' => 1
            ],
            'representante_legal' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false,
                'max_length' => 250
            ],
            'email_representante_legal' => [
                'type' => 'email',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false,
                'max_length' => 254
            ],
            'telefono_representante_legal' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false,
                'max_length' => 11,
                'min_length' => 11
            ],
            'fecha_inicio_operacion' => [
                'type' => 'date',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false,
            ],
            'fecha_termino_operacion' => [
                'type' => 'date',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false,
            ],
            'id_tipo_organizacion' => [
                'type' => 'integer',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => false,
                'min' => 1,
                'max' => 99999999999
            ],
            'estado' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'isStatus' => true,
                'max_length' => 11,
                'min_length' => 5                
            ]          
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
    public static function validateCreateTypeBusiness($data){
        $validationRules = [
            'tipo_organizacion' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 50
            ]
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
    public static function validateUpdateTypeBusiness($data){
        $validationRules = [
            'tipo_organizacion' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 50
            ]
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
}

?>