<?php
require_once 'controllers/EmpresaController.php';
require_once 'utils/ValidateFieldRule.php';

class Router {
    private $controller;
    private $method;
    private $uri;
    private $id;
    private $typeResource;
    private $header;

    public function __construct($mysqli,$header) {
        $this->method = $_SERVER['REQUEST_METHOD'];
        $this->uri = $_SERVER['REQUEST_URI'];
        $partes = array_filter(explode('/', rtrim($this->uri, '/')));
        $resource = isset($partes[3]) ? $partes[3] : '';
        $this->typeResource = $resource;
        $this->id = isset($partes[4]) && is_numeric($partes[4]) ? (int)$partes[4] : null;
        $this->controller = new EmpresaController($mysqli,$header);
        $this->header = $header;
    }

    public function route() {
        switch ($this->method) {
            case 'GET':
                if($this->header['User-Id'] == '31') ApiResponse::success('S001',[]);
                switch($this->typeResource){
                    case 'resumen-general':
                        $this->controller->resumenGeneral();
                        break;
                    case 'resumen':
                        $this->controller->resumen();
                        break;
                    case 'listar':
                        $this->controller->listarEmpresas();
                        break;
                    case 'tipo-organizacion':
                        $this->controller->listarTipoOrganizacion();
                        break;
                    case 'listar-activas':
                        $this->controller->listarEmpresasActivas();
                        break;
                    default:
                        ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            case 'POST':
                switch ($this->typeResource) {
                    case 'crear-empresa':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateData::validateCreationBusiness($data)) ApiResponse::error('E400',$error);
                        $this->controller->crearEmpresa($data);
                        break;
                    case 'crear-tipo-organizacion':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateData::validateCreateTypeBusiness($data)) ApiResponse::error('E400',$error);
                        $this->controller->crearTipoEmpresa($data);
                        break;
                    default:
                        ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }               
                break;
            case 'PATCH':
                if($this->header['User-Id'] == '31') ApiResponse::error('E404');
                switch ($this->typeResource) {
                    case 'actualizar-empresa':
                        if(!$this->id)ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateData::validateUpdateBusiness($data)) ApiResponse::error('E400',$error);
                        $this->controller->actualizarEmpresa($this->id, $data);
                        break;
                    case 'actualizar-tipo-organizacion':
                        if(!$this->id)ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateData::validateUpdateTypeBusiness($data)) ApiResponse::error('E400',$error);
                        $this->controller->actualizarTipoOrganizacion($this->id, $data);
                        break;
                    case 'bloquear-empresa':
                        if(!$this->id)ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                        $this->controller->bloquearEmpresa($this->id);
                        break;
                    default:
                        ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            case 'DELETE':
                switch ($this->typeResource) {
                    case 'eliminar-empresa':
                        if(!$this->id)ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                        $this->controller->deleteEmpresa($this->id);
                        break;
                    case 'eliminar-tipo-organizacion':
                        if(!$this->id)ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                        $this->controller->deleteTipoEmpresa($this->id);
                        break;
                    default:
                        ApiResponse::error('E402','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            default:
                ApiResponse::error('E405');
                break;
        }
    }
}
?>